<?php
/* ********************************************************************************
 * The content of this file is subject to the MultiWarehouses4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouWarehouses_DetailView_Model extends Vtiger_DetailView_Model
{

    public function getDetailViewLinks($linkParams)
    {
        $linkModelList = parent::getDetailViewLinks($linkParams);

        unset($linkModelList["DETAILVIEWSETTING"]);

        $currentUserModel = Users_Record_Model::getCurrentUserModel();
        if ($currentUserModel->isAdminUser()) {
            $settingsLinks = $this->getModule()->getSettingLinks();
            foreach ($settingsLinks as $settingsLink) {
                //in DetailView we don't want to display link for recalculation of all warehouses
                //even more it's better to display it in More links
                if ($settingsLink["linklabel"] != "LBL_RECALCULATE_WAREHOUSES") {
                    $linkModelList['DETAILVIEWSETTING'][] = Vtiger_Link_Model::getInstanceFromValues($settingsLink);
                }
            }
        }

        //add recaulculate link to 'More' links
        $recalculateLinkModel = array(
            'linktype' => 'DETAILVIEW',
            'linklabel' => 'LBL_RECALCULATE_WAREHOUSE',
            'linkurl' => 'javascript:ITS4YouUtils_Js.recalculateWarehouses(' . $this->record->getId() . ');',
            'linkicon' => ''
        );
        $linkModelList['DETAILVIEW'][] = Vtiger_Link_Model::getInstanceFromValues($recalculateLinkModel);

        return $linkModelList;
    }

    public function getDetailViewRelatedLinks()
    {
        $recordModel = $this->getRecord();
        $moduleName = $recordModel->getModuleName();
        $parentModuleModel = $this->getModule();

        $relatedLinks = parent::getDetailViewRelatedLinks();

        $relatedLinks[] = array(
            'linktype' => 'DETAILVIEWTAB',
            'linklabel' => 'LBL_PRODUCTS_ON_WAREHOUSE',
            'linkurl' => $recordModel->getDetailViewUrl() . '&mode=showProductsInWarehouse&page=1',
            'linkicon' => ''
        );

        return $relatedLinks;
    }

}
