<?php

/* * *******************************************************************************
 * The content of this file is subject to the MultiWarehouses4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouWarehouses_Util_Helper
{

    public static function transferListSearchParamsToFilterCondition($listSearchParams, $fieldModels)
    {
        if (empty($listSearchParams)) {
            $listSearchParams = array();
        }
        $advFilterConditionFormat = array();
        $glueOrder = array('and', 'or');
        $groupIterator = 0;
        foreach ($listSearchParams as $groupInfo) {
            if (empty($groupInfo)) {
                continue;
            }
            $groupConditionInfo = array();
            $groupColumnsInfo = array();
            $groupConditionGlue = $glueOrder[$groupIterator];
            foreach ($groupInfo as $fieldSearchInfo) {
                $advFilterFieldInfoFormat = array();
                $fieldName = $fieldSearchInfo[0];
                $operator = $fieldSearchInfo[1];
                $fieldValue = $fieldSearchInfo[2];
                $fieldInfo = $fieldModels[$fieldName];

                //Request will be having in terms of AM and PM but the database will be having in 24 hr format so converting
                //Database format

                if ($fieldInfo->getFieldDataType() == "time") {
                    $fieldValue = Vtiger_Time_UIType::getTimeValueWithSeconds($fieldValue);
                }

                if ($fieldName == 'amount' && $fieldInfo->getFieldDataType() == 'currency') {
                    $fieldValue = CurrencyField::convertToDBFormat($fieldValue);
                }

                if ($fieldName == 'date_start' || $fieldName == 'due_date' || $fieldInfo->getFieldDataType() == "datetime") {
                    $dateValues = explode(',', $fieldValue);
                    //Indicate whether it is fist date in the between condition
                    $isFirstDate = true;
                    foreach ($dateValues as $key => $dateValue) {
                        $dateTimeCompoenents = explode(' ', $dateValue);
                        if (empty($dateTimeCompoenents[1])) {
                            if ($isFirstDate) {
                                $dateTimeCompoenents[1] = '00:00:00';
                            } else {
                                $dateTimeCompoenents[1] = '23:59:59';
                            }
                        }
                        $dateValue = implode(' ', $dateTimeCompoenents);
                        $dateValues[$key] = $dateValue;
                        $isFirstDate = false;
                    }
                    $fieldValue = implode(',', $dateValues);
                }

                $advFilterFieldInfoFormat['columnname'] = $fieldInfo->getCustomViewColumnName();
                $advFilterFieldInfoFormat['comparator'] = $operator;
                $advFilterFieldInfoFormat['value'] = $fieldValue;
                $advFilterFieldInfoFormat['column_condition'] = $groupConditionGlue;
                $groupColumnsInfo[] = $advFilterFieldInfoFormat;
            }
            $noOfConditions = count($groupColumnsInfo);
            //to remove the last column condition
            $groupColumnsInfo[$noOfConditions - 1]['column_condition'] = '';
            $groupConditionInfo['columns'] = $groupColumnsInfo;
            $groupConditionInfo['condition'] = 'and';
            $advFilterConditionFormat[] = $groupConditionInfo;
            $groupIterator++;
        }
        //We aer removing last condition since this condition if there is next group and this is the last group
        unset($advFilterConditionFormat[count($advFilterConditionFormat) - 1]['condition']);
        return $advFilterConditionFormat;
    }

    /**
     * @param string $moduleName
     * @return string
     */
    public static function getStatusField($moduleName)
    {
        $statusFields = [
            'ITS4YouWHDeliveryNotes' => 'deliverynotestatus',
            'ITS4YouIssuecards' => 'issuecardstatus',
            'ITS4YouWarehouseTransfers' => 'wtstatus',
            'ITS4YouReceiptcards' => 'receiptcardstatus',
        ];

        return $statusFields[$moduleName];
    }
}
