<?php

/* * *******************************************************************************
 * The content of this file is subject to the MultiWarehouses4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouWarehouses_JsUtilsHandler_Helper
{

    /** @var Vtiger_Request */
    private static $request;

    /** @var Vtiger_Viewer */
    private static $viewer;

    /** @var string */
    private static $module;

    /**
     * @param Vtiger_Request $request
     * @param Vtiger_Viewer $viewer
     * @throws Exception
     */
    public static function handle(Vtiger_Request $request, Vtiger_Viewer $viewer)
    {
        self::$request = $request;
        self::$viewer = $viewer;
        self::$module = 'ITS4YouWarehouses';

        $mode = $request->get("mode");
        switch ($mode) {
            case "recalculate":
                self::handleRecalculate();
                break;

            case "returnProducts":
                self::handleReturnProducts();
                break;

            default:
                throw new Exception("Warehouses :: Unsupported action mode JsUtilsHandler.");
        }
    }

    private static function handleRecalculate()
    {
        $productId = self::$request->get('productId', false);
        $warehouseId = self::$request->get('warehouseId', false);

        $recalculator = new ITS4YouWarehouses_QtyRecalculator_Helper();
        if ($productId === false && $warehouseId === false) {
            $recalculator->recalculateAll();
            echo vtranslate('LBL_RECALCULATING_IS_DONE', self::$module);
        } elseif ($productId !== false) {
            $recalculator->recalculateSingleProduct($productId);
            echo vtranslate('LBL_RECALCULATING_SINGLE_IS_DONE', self::$module);
        } elseif ($warehouseId !== false) {
            $recalculator->recalculateSingleWarehouse($warehouseId);
            echo vtranslate('LBL_RECALCULATING_SINGLE_WH_IS_DONE', self::$module);
        }
    }

    /**
     * @throws Exception
     */
    private static function handleReturnProducts()
    {
        $sourceModule = self::$request->get('sourceModule');
        $sourceRecord = self::$request->get('sourceRecord');

        self::$viewer->assign('MODULE', self::$module);
        self::$viewer->assign('SOURCE_MODULE', $sourceModule);
        self::$viewer->assign('RECORD', $sourceRecord);

        $actionBlock = ITS4YouWarehouses_Base_ActionBlock::factory($sourceModule, $sourceRecord);
        $viewModel = $actionBlock->getReturnProductsViewModel();

        self::$viewer->assign('VIEWMODEL', $viewModel);
        self::$viewer->view('ActionBlockActionReturnProducts.tpl', self::$module);
    }
}
