<?php

/* * *******************************************************************************
 * The content of this file is subject to the DeliveryNotes4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */
require_once __DIR__ . '/../handlers/CrossInventoryRel.php';

class ITS4YouWarehouses_InventoryUtils_Helper
{

	/**
	 * @param $_focus
	 * @return array
	 * @throws Exception
	 */
	public static function getAssociatedProducts($_focus)
	{
		$adb = PearDatabase::getInstance();

		$seid = 0;
		$no_of_decimal_places = getCurrencyDecimalPlaces();
		$product_Detail = Array();

		$query = "  SELECT
                        case when vtiger_products.productid != '' then vtiger_products.productname else vtiger_service.servicename end as productname,
                        case when vtiger_products.productid != '' then vtiger_products.product_no else vtiger_service.service_no end as productcode,
                        case when vtiger_products.productid != '' then vtiger_products.unit_price else vtiger_service.unit_price end as unit_price,
                        case when vtiger_products.productid != '' then vtiger_products.qtyinstock else 'NA' end as qtyinstock,
                        case when vtiger_products.productid != '' then 'Products' else 'Services' end as entitytype,
                        vtiger_inventoryproductrel.listprice,
                        vtiger_inventoryproductrel.description AS product_description,
                        vtiger_inventoryproductrel.*,vtiger_crmentity.deleted,vtiger_crmentity.label
                    FROM vtiger_inventoryproductrel
                    LEFT JOIN vtiger_crmentity 
                           ON vtiger_crmentity.crmid=vtiger_inventoryproductrel.productid
 		            LEFT JOIN vtiger_products
                           ON vtiger_products.productid=vtiger_inventoryproductrel.productid
                    LEFT JOIN vtiger_service
                           ON vtiger_service.serviceid=vtiger_inventoryproductrel.productid
                    WHERE id=?
 		    ORDER BY sequence_no";
		$params = array($_focus->id);

		$result = $adb->pquery($query, $params);
		$num_rows = $adb->num_rows($result);
		for ($i = 1; $i <= $num_rows; $i++) {
			$deleted = $adb->query_result($result, $i - 1, 'deleted');
			$hdnProductId = $adb->query_result($result, $i - 1, 'productid');
			$lineItemId = $adb->query_result($result, $i - 1, 'lineitem_id');
			$hdnProductcode = $adb->query_result($result, $i - 1, 'productcode');
			$productname = $adb->query_result($result, $i - 1, 'productname');
			$productLabel = $adb->query_result($result, $i - 1, 'label');
			$productdescription = $adb->query_result($result, $i - 1, 'product_description');
			$comment = $adb->query_result($result, $i - 1, 'comment');
			$qtyinstock = $adb->query_result($result, $i - 1, 'qtyinstock');
			$qty = $adb->query_result($result, $i - 1, 'quantity');
			$unitprice = $adb->query_result($result, $i - 1, 'unit_price');
			$listprice = $adb->query_result($result, $i - 1, 'listprice');
			$entitytype = $adb->query_result($result, $i - 1, 'entitytype');

			if (($deleted) || (!isset($deleted))) {
				$product_Detail[$i]['productDeleted' . $i] = true;
			} elseif (!$deleted) {
				$product_Detail[$i]['productDeleted' . $i] = false;
			}

			if (!empty($entitytype)) {
				$product_Detail[$i]['entityType' . $i] = $entitytype;
			}

			if ($listprice == '' || $listprice == 0)
				$listprice = $unitprice;
			if ($qty == '')
				$qty = 1;

			//calculate productTotal
			$productTotal = $qty * $listprice;

			//Delete link in First column
			if ($i != 1) {
				$product_Detail[$i]['delRow' . $i] = "Del";
			}
            if (empty($_focus->mode) && $seid != '') {
                $sub_prod_query = $adb->pquery('SELECT crmid as prod_id, quantity from vtiger_seproductsrel WHERE productid=? AND setype=?',
                    array($seid, 'Products')
                );
            } else {
                $sub_prod_query = $adb->pquery('SELECT productid as prod_id, quantity from vtiger_inventorysubproductrel WHERE id=? AND sequence_no=?',
                    array($_focus->id, $i)
                );
            }

			$subprodid_str = '';
			$subprodname_str = '';
			$subProductArray = array();

            if ($adb->num_rows($sub_prod_query)) {
                for ($j = 0; $j < $adb->num_rows($sub_prod_query); $j++) {
                    $sprod_id = $adb->query_result($sub_prod_query, $j, 'prod_id');
                    $sprod_qty = $adb->query_result($sub_prod_query, $j, 'quantity');
                    $sprod_name = $subProductArray[] = getProductName($sprod_id);
                    $subprodid_str .= "$sprod_id:$sprod_qty,";

                    if (isRecordExists($sprod_id) && 'Detail' === $_REQUEST['view']) {
                        $subprodname_str .= "<a href='index.php?module=Products&view=Detail&record=$sprod_id' target='_blank'> <em> - $sprod_name ($sprod_qty)</em><br></a>";
                    } else {
                        $subprodname_str .= "<em> - $sprod_name ($sprod_qty)</em><br>";
                    }
                }
            }

            $subprodid_str = rtrim($subprodid_str, ',');

			$product_Detail[$i]['subProductArray' . $i] = $subProductArray;
			$product_Detail[$i]['hdnProductId' . $i] = $hdnProductId;
			$product_Detail[$i]['lineItemId' . $i] = $lineItemId;
			$product_Detail[$i]['productName' . $i] = from_html($productLabel);
			$product_Detail[$i]['hdnProductcode' . $i] = $hdnProductcode;
			$product_Detail[$i]['productDescription' . $i] = from_html($productdescription);
			$product_Detail[$i]['comment' . $i] = decode_html($comment);

//            if ($module != 'PurchaseOrder' && $_focus->object_name != 'Order') {
//                $product_Detail[$i]['qtyInStock' . $i] = decimalFormat($qtyinstock);
//            }
			$product_Detail[$i]['qtyInStock' . $i] = decimalFormat($qtyinstock);

			$listprice = number_format($listprice, $no_of_decimal_places, '.', '');
			$product_Detail[$i]['qty' . $i] = decimalFormat($qty);
			$product_Detail[$i]['listPrice' . $i] = $listprice;
			$product_Detail[$i]['unitPrice' . $i] = number_format($unitprice, $no_of_decimal_places, '.', '');
			$product_Detail[$i]['productTotal' . $i] = $productTotal;
			$product_Detail[$i]['subproduct_ids' . $i] = $subprodid_str;
			$product_Detail[$i]['subprod_names' . $i] = $subprodname_str;
			$discount_percent = decimalFormat($adb->query_result($result, $i - 1, 'discount_percent'));
			$discount_amount = $adb->query_result($result, $i - 1, 'discount_amount');
			$discount_amount = decimalFormat(number_format($discount_amount, $no_of_decimal_places, '.', ''));
			$discountTotal = '0';
			//Based on the discount percent or amount we will show the discount details
			//To avoid NaN javascript error, here we assign 0 initially to' %of price' and 'Direct Price reduction'(for Each Product)
			$product_Detail[$i]['discount_percent' . $i] = 0;
			$product_Detail[$i]['discount_amount' . $i] = 0;

			if (!empty($discount_percent)) {
				$product_Detail[$i]['discount_type' . $i] = "percentage";
				$product_Detail[$i]['discount_percent' . $i] = $discount_percent;
				$product_Detail[$i]['checked_discount_percent' . $i] = ' checked';
				$product_Detail[$i]['style_discount_percent' . $i] = ' style="visibility:visible"';
				$product_Detail[$i]['style_discount_amount' . $i] = ' style="visibility:hidden"';
				$discountTotal = $productTotal * $discount_percent / 100;
			} elseif (!empty($discount_amount)) {
				$product_Detail[$i]['discount_type' . $i] = "amount";
				$product_Detail[$i]['discount_amount' . $i] = $discount_amount;
				$product_Detail[$i]['checked_discount_amount' . $i] = ' checked';
				$product_Detail[$i]['style_discount_amount' . $i] = ' style="visibility:visible"';
				$product_Detail[$i]['style_discount_percent' . $i] = ' style="visibility:hidden"';
				$discountTotal = $discount_amount;
			} else {
				$product_Detail[$i]['checked_discount_zero' . $i] = ' checked';
			}
			$totalAfterDiscount = $productTotal - $discountTotal;
			$totalAfterDiscount = number_format($totalAfterDiscount, $no_of_decimal_places, '.', '');
			$discountTotal = number_format($discountTotal, $no_of_decimal_places, '.', '');
			$product_Detail[$i]['discountTotal' . $i] = $discountTotal;
			$product_Detail[$i]['totalAfterDiscount' . $i] = $totalAfterDiscount;

			$taxTotal = '0';
			$taxTotal = number_format($taxTotal, $no_of_decimal_places, '.', '');
			$product_Detail[$i]['taxTotal' . $i] = $taxTotal;

			//Calculate netprice
			$netPrice = floatval($totalAfterDiscount) + floatval($taxTotal);
			$taxtype = self::getInventoryTaxType($_focus);
			if ($taxtype == 'individual') {
				//Add the tax with product total and assign to netprice
				$netPrice = floatval($netPrice) + floatval($taxTotal);
			}

			$product_Detail[$i]['netPrice' . $i] = $netPrice;

			//First we will get all associated taxes as array
			$tax_details = getTaxDetailsForProduct($hdnProductId, 'all');
			//Now retrieve the tax values from the current query with the name
			for ($tax_count = 0; $tax_count < count($tax_details); $tax_count++) {
				$tax_name = $tax_details[$tax_count]['taxname'];
				$tax_label = $tax_details[$tax_count]['taxlabel'];

				//condition to avoid this function call when create new PO/SO/Quotes/Invoice from Product module
				if ($_focus->id != '') {
					if ($taxtype == 'individual')//if individual then show the entered tax percentage
						$tax_value = getInventoryProductTaxValue($_focus->id, $hdnProductId, $tax_name);
					else//if group tax then we have to show the default value when change to individual tax
						$tax_value = $tax_details[$tax_count]['percentage'];
				} else//if the above function not called then assign the default associated value of the product
					$tax_value = $tax_details[$tax_count]['percentage'];

				$product_Detail[$i]['taxes'][$tax_count]['taxname'] = $tax_name;
				$product_Detail[$i]['taxes'][$tax_count]['taxlabel'] = $tax_label;
				$product_Detail[$i]['taxes'][$tax_count]['percentage'] = $tax_value;
			}
		}

		//set the taxtype
		$product_Detail[1]['final_details']['taxtype'] = $taxtype;

		//Get the Final Discount, S&H charge, Tax for S&H and Adjustment values
		//To set the Final Discount details
		$finalDiscount = '0';
		$product_Detail[1]['final_details']['discount_type_final'] = 'zero';

		$subTotal = ($_focus->column_fields['hdnSubTotal'] != '') ? $_focus->column_fields['hdnSubTotal'] : '0';
		$subTotal = number_format($subTotal, $no_of_decimal_places, '.', '');

		$product_Detail[1]['final_details']['hdnSubTotal'] = $subTotal;
		$discountPercent = ($_focus->column_fields['hdnDiscountPercent'] != '') ? $_focus->column_fields['hdnDiscountPercent'] : '0';
		$discountAmount = ($_focus->column_fields['hdnDiscountAmount'] != '') ? $_focus->column_fields['hdnDiscountAmount'] : '0';
		if ($discountPercent != '0') {
			$discountAmount = ($product_Detail[1]['final_details']['hdnSubTotal'] * $discountPercent / 100);
		}

		//To avoid NaN javascript error, here we assign 0 initially to' %of price' and 'Direct Price reduction'(For Final Discount)
		$discount_amount_final = '0';
		$discount_amount_final = number_format($discount_amount_final, $no_of_decimal_places, '.', '');
		$product_Detail[1]['final_details']['discount_percentage_final'] = 0;
		$product_Detail[1]['final_details']['discount_amount_final'] = $discount_amount_final;

		//fix for opensource issue not saving invoice data properly
		if (!empty($_focus->column_fields['hdnDiscountPercent'])) {
			$finalDiscount = ($subTotal * $discountPercent / 100);
			$product_Detail[1]['final_details']['discount_type_final'] = 'percentage';
			$product_Detail[1]['final_details']['discount_percentage_final'] = $discountPercent;
			$product_Detail[1]['final_details']['checked_discount_percentage_final'] = ' checked';
			$product_Detail[1]['final_details']['style_discount_percentage_final'] = ' style="visibility:visible"';
			$product_Detail[1]['final_details']['style_discount_amount_final'] = ' style="visibility:hidden"';
		} //fix for opensource issue not saving invoice data properly
		elseif (!empty($_focus->column_fields['hdnDiscountAmount'])) {
			$finalDiscount = $_focus->column_fields['hdnDiscountAmount'];
			$product_Detail[1]['final_details']['discount_type_final'] = 'amount';
			$product_Detail[1]['final_details']['discount_amount_final'] = $discountAmount;
			$product_Detail[1]['final_details']['checked_discount_amount_final'] = ' checked';
			$product_Detail[1]['final_details']['style_discount_amount_final'] = ' style="visibility:visible"';
			$product_Detail[1]['final_details']['style_discount_percentage_final'] = ' style="visibility:hidden"';
		}
		$finalDiscount = number_format($finalDiscount, $no_of_decimal_places, '.', '');
		$product_Detail[1]['final_details']['discountTotal_final'] = $finalDiscount;

		//To set the Final Tax values
		//we will get all taxes. if individual then show the product related taxes only else show all taxes
		//suppose user want to change individual to group or vice versa in edit time the we have to show all taxes. so that here we will store all the taxes and based on need we will show the corresponding taxes

		$taxtotal = '0';
		//First we should get all available taxes and then retrieve the corresponding tax values
		$tax_details = getAllTaxes('available', '', 'edit', $_focus->id);

		for ($tax_count = 0; $tax_count < count($tax_details); $tax_count++) {
			$tax_name = $tax_details[$tax_count]['taxname'];
			$tax_label = $tax_details[$tax_count]['taxlabel'];

			//if taxtype is individual and want to change to group during edit time then we have to show the all available taxes and their default values
			//Also taxtype is group and want to change to individual during edit time then we have to provide the asspciated taxes and their default tax values for individual products
			if ($taxtype == 'group')
				$tax_percent = $adb->query_result($result, 0, $tax_name);
			else
				$tax_percent = $tax_details[$tax_count]['percentage']; //$adb->query_result($result,0,$tax_name);

			if ($tax_percent == '' || $tax_percent == 'NULL')
				$tax_percent = '0';
			$taxamount = ($subTotal - $finalDiscount) * $tax_percent / 100;
			$taxamount = number_format($taxamount, $no_of_decimal_places, '.', '');
			$taxtotal = floatval($taxtotal) + floatval($taxamount);
			$product_Detail[1]['final_details']['taxes'][$tax_count]['taxname'] = $tax_name;
			$product_Detail[1]['final_details']['taxes'][$tax_count]['taxlabel'] = $tax_label;
			$product_Detail[1]['final_details']['taxes'][$tax_count]['percentage'] = $tax_percent;
			$product_Detail[1]['final_details']['taxes'][$tax_count]['amount'] = $taxamount;
		}
		$product_Detail[1]['final_details']['tax_totalamount'] = $taxtotal;

		//To set the Shipping & Handling charge
		$shCharge = ($_focus->column_fields['hdnS_H_Amount'] != '') ? $_focus->column_fields['hdnS_H_Amount'] : '0.00';
		$shCharge = number_format($shCharge, $no_of_decimal_places, '.', '');
		$product_Detail[1]['final_details']['shipping_handling_charge'] = $shCharge;

		//To set the Shipping & Handling tax values
		//calculate S&H tax
		$shtaxtotal = '0';
		//First we should get all available taxes and then retrieve the corresponding tax values
		$shtax_details = getAllTaxes('available', 'sh', 'edit', $_focus->id);

		//if taxtype is group then the tax should be same for all products in vtiger_inventoryproductrel table
		for ($shtax_count = 0; $shtax_count < count($shtax_details); $shtax_count++) {
			$shtax_name = $shtax_details[$shtax_count]['taxname'];
			$shtax_label = $shtax_details[$shtax_count]['taxlabel'];
			//if condition is added to call this function when we create PO/SO/Quotes/Invoice from Product module
			$shtax_percent = getInventorySHTaxPercent($_focus->id, $shtax_name);
			$shtaxamount = $shCharge * $shtax_percent / 100;
			$shtaxtotal = floatval($shtaxtotal) + floatval($shtaxamount);
			$product_Detail[1]['final_details']['sh_taxes'][$shtax_count]['taxname'] = $shtax_name;
			$product_Detail[1]['final_details']['sh_taxes'][$shtax_count]['taxlabel'] = $shtax_label;
			$product_Detail[1]['final_details']['sh_taxes'][$shtax_count]['percentage'] = $shtax_percent;
			$product_Detail[1]['final_details']['sh_taxes'][$shtax_count]['amount'] = $shtaxamount;
		}
		$shtaxtotal = number_format($shtaxtotal, $no_of_decimal_places, '.', '');
		$product_Detail[1]['final_details']['shtax_totalamount'] = $shtaxtotal;

		//To set the Adjustment value
		$adjustment = ($_focus->column_fields['txtAdjustment'] != '') ? $_focus->column_fields['txtAdjustment'] : '0';
		$adjustment = number_format($adjustment, $no_of_decimal_places, '.', '');
		$product_Detail[1]['final_details']['adjustment'] = $adjustment;

		//To set the grand total
		$grandTotal = ($_focus->column_fields['hdnGrandTotal'] != '') ? $_focus->column_fields['hdnGrandTotal'] : '0';
		$grandTotal = number_format($grandTotal, $no_of_decimal_places, '.', '');
		$product_Detail[1]['final_details']['grandTotal'] = $grandTotal;

		return $product_Detail;
	}

	/**
	 * @param $_focus
	 * @param $_lineItems
	 * @return mixed
	 * @throws Exception
	 */
	public static function getAssociatedProductsModified($_focus, $_lineItems)
	{
		$tmpAssociatedProducts = self::getAssociatedProducts($_focus);
		$filteredIdx = 1;
		$filteredAssocProducts = array();
		$noDecPlaces = Users_Record_Model::getCurrentUserModel()->get("no_of_currency_decimals");
		foreach ($tmpAssociatedProducts as $idx => $prodData) {
			$lineItemId = $prodData["lineItemId" . $idx];
			if (isset($_lineItems[$lineItemId])) {
				/* @var $lineItem ITS4YouWarehouses_InventoryLineItem_Helper */
				$lineItem = $_lineItems[$lineItemId];
				$newProdData = $prodData;

				$newProdData["qty" . $idx] = number_format($lineItem->getQuantity(), $noDecPlaces, ".", "");
				$newProdData["comment" . $idx] = $lineItem->getComment();
				$newProdData["listPrice" . $idx] = number_format($lineItem->getPrice(), $noDecPlaces, ".", "");

				$productTotal = $lineItem->getQuantity() * $lineItem->getPrice();
				$newProdData["productTotal" . $idx] = number_format($productTotal, $noDecPlaces, ".", "");
				$newProdData["totalAfterDiscount" . $idx] = $newProdData["netPrice" . $idx] = $newProdData["productTotal" . $idx];
				$newProdData["discount_amount" . $idx] = $newProdData["discount_percent" . $idx] = $newProdData["discountTotal" . $idx] = 0;

				foreach ($newProdData as $key => $val) {
                    $filteredKey = ITS4YouWarehouses_Products_Helper::fixFieldIndex($filteredIdx, $key);
					$filteredAssocProducts[$filteredIdx][$filteredKey] = $val;
				}
				$filteredIdx++;
			}
		}
		$associated_prod = self::adjustFinalDetails($filteredAssocProducts);

		return $associated_prod;
	}

	/**
	 * @param $_focus
	 * @return array
	 * @throws Exception
	 */

	public static function getParentInventoryCurrencyInfo($_focus)
	{
		$adb = PearDatabase::getInstance();
		$res = $adb->pquery("select currency_id, " . $_focus->table_name . ".conversion_rate as conv_rate, vtiger_currency_info.* from " . $_focus->table_name . "
                                inner join vtiger_currency_info on " . $_focus->table_name . ".currency_id = vtiger_currency_info.id
                                where " . $_focus->table_index . "=?", array($_focus->id));

		$row = $adb->query_result_rowdata($res);

		$currency_info = array();
		$currency_info['currency_id'] = $row['currency_id'];
		$currency_info['conversion_rate'] = $row['conv_rate'];
		$currency_info['currency_name'] = $row['currency_name'];
		$currency_info['currency_code'] = $row['currency_code'];
		$currency_info['currency_symbol'] = $row['currency_symbol'];

		return $currency_info;
	}

	private static function getInventoryTaxType($_focus)
	{
		global $adb;
		$res = $adb->pquery("select taxtype from " . $_focus->table_name . " where " . $_focus->table_index . "=?", array($_focus->id));
		$taxtype = $adb->query_result($res, 0, 'taxtype');

		return $taxtype;
	}

	/**
	 * Prepare $_REQUEST for saving inventory items
	 * @param array $_lineItems Array of InventoryLineItems instances
	 */
	public static function prepareRequestForAssociatedLineItems($_lineItems)
	{
		$adb = PearDatabase::getInstance();
		$subtotal = 0;
		$productIds = array();

        /** @var ITS4YouWarehouses_InventoryLineItem_Helper $lineItem */
		foreach ($_lineItems as $lineItem) {
			$productId = $lineItem->getProductId();
			$productIds[$productId] = $productId;
		}
		//get array of default unit prices of products
		$unitPrices = array();
		$sql = "SELECT productid, unit_price
                FROM vtiger_products                    
                WHERE vtiger_products.productid IN (" . generateQuestionMarks($productIds) . ")";
		$result = $adb->pquery($sql, $productIds);
		if ($adb->num_rows($result) > 0) {
			while ($row = $adb->fetchByAssoc($result)) {
				$unitPrices[$row["productid"]] = $row["unit_price"];
			}
		}
		//get tax details
		$taxDetails = Array();
		$sql = 'SELECT * FROM vtiger_inventorytaxinfo WHERE deleted=0';
		$res = $adb->query($sql);
		while ($row = $adb->fetchByAssoc($res)) {
			$taxDetails[$row['taxid']] = $row;
		}
		//prepare $_REQUEST
		$iterator = 0;
		foreach ($_lineItems as $lineItem) {
			$iterator++;

            $subProducts = $lineItem->getSubProductsToRequest();

            if (!empty($subProducts)) {
                $_REQUEST['subproduct_ids' . $iterator] = $subProducts;
            }

			// passing lineItemId array to REQUEST for CrossInventoryRelEventHandler.class.php
			$_REQUEST['lineItemId' . $iterator] = $lineItem->getItemId();
			$_REQUEST['hdnProductId' . $iterator] = $lineItem->getProductId();
			$_REQUEST['qty' . $iterator] = $lineItem->getQuantity();
			$listPrice = ($lineItem->getPrice() < 0 ? $unitPrices[$lineItem->getProductId()] : $lineItem->getPrice());
			$_REQUEST['listPrice' . $iterator] = $listPrice;
			$_REQUEST['comment' . $iterator] = $lineItem->getComment();
			$_REQUEST['deleted' . $iterator] = 0;
			$_REQUEST['discount_type' . $iterator] = $lineItem->getDiscountType();
			$_REQUEST['discount_amount' . $iterator] = $lineItem->getDiscountAmount();
			$_REQUEST['discount_percentage' . $iterator] = $lineItem->getDiscountPercent();

			$taxes_amount = 0;
			if (count($taxDetails) > 0) {
				$sql = "SELECT * FROM vtiger_producttaxrel WHERE productid = ? AND taxid IN (" . generateQuestionMarks(array_keys($taxDetails)) . ")";
				$params = array_merge(array($lineItem->getProductId()), array_keys($taxDetails));
				$res = $adb->pquery($sql, $params);
				while ($row = $adb->fetchByAssoc($res)) {
					$_REQUEST[$taxDetails[$row['taxid']]['taxname'] . '_percentage' . $iterator] = $row['taxpercentage'];
					$taxes_amount += floatval($listPrice) * floatval($row['taxpercentage']) / 100;
				}
			}
			$subtotal += floatval($lineItem->getQuantity()) * ($listPrice + $taxes_amount);
		}
		$_REQUEST['totalProductCount'] = $iterator;
		$_REQUEST['taxtype'] = 'individual';
		$_REQUEST['subtotal'] = $subtotal;
		$_REQUEST['discount_type_final'] = 'amount';
		$_REQUEST['discount_amount_final'] = '0';
		$_REQUEST['shipping_handling_charge'] = '0';
		$_REQUEST['adjustmenttype'] = '+';
		$_REQUEST['adjustment'] = '0';
		$_REQUEST['total'] = $subtotal;
	}

	/**
	 * @param $focus
	 * @param $toDeliverQuantities
	 * @throws Exception
	 */
	public static function prepareRequestForExistingProducts($focus, $toDeliverQuantities)
	{
		$no_of_decimal_places = getCurrencyDecimalPlaces();

		$relatedProducts = self::getAssociatedProducts($focus);
		//adjust related products qith modified qty or other attributes
		$subTotal = 0;

		$taxType = $relatedProducts[1]['final_details']['taxtype'];
		foreach ($relatedProducts as $itemIdx => $itemData) {
			$lineItemId = $itemData["lineItemId" . $itemIdx];

			if (isset($toDeliverQuantities[$lineItemId])) {
				$newQty = $toDeliverQuantities[$lineItemId];
				//adjust quantity
				$relatedProducts[$itemIdx]["qty" . $itemIdx] = decimalFormat($newQty);
				//adjust productTotal
				$productTotal = $itemData["listPrice" . $itemIdx] * $newQty;
				$relatedProducts[$itemIdx]["productTotal" . $itemIdx] = $productTotal;

				//adjust discountTotal
				$discountTotal = 0;
				if ($itemData["discount_type" . $itemIdx] == "percentage") {
					$discountTotal = $productTotal * $itemData["discount_percent" . $itemIdx] / 100;
				} elseif ($itemData["discount_type" . $itemIdx] == "amount") {
					$discountTotal = $itemData["discount_amount" . $itemIdx];
				}
				$relatedProducts[$itemIdx]["discountTotal" . $itemIdx] = number_format($discountTotal, $no_of_decimal_places, '.', '');
				//adjust totalAfterDiscount
				$totalAfterDiscount = $productTotal - $discountTotal;
				$relatedProducts[$itemIdx]["totalAfterDiscount" . $itemIdx] = number_format($totalAfterDiscount, $no_of_decimal_places, '.', '');

				//handle taxes
				$productTaxTotal = 0;
				if ($taxType == "individual") {
					$taxes_for_product = $itemData["taxes"];
					for ($tax_count = 0; $tax_count < count($taxes_for_product); $tax_count++) {
						$tax_name = $taxes_for_product[$tax_count]['taxname'];
						$tax_percent = $taxes_for_product[$tax_count]['percentage'];
						$request_tax_name = $tax_name . "_percentage" . $itemIdx;
						$_REQUEST[$request_tax_name] = $tax_percent;
						//it's needed to calculate tax total
						$productTaxTotal += $totalAfterDiscount * $tax_percent / 100;
					}
				}

				//Calculate netprice
				$netPrice = $totalAfterDiscount + $productTaxTotal;
				$relatedProducts[$itemIdx]["netPrice" . $itemIdx] = number_format($netPrice, $no_of_decimal_places, '.', '');

				$subTotal += $netPrice;
			} else {
				$relatedProducts[$itemIdx]["productDeleted" . $itemIdx] = true;
			}
		}
		$subTotal = number_format($subTotal, $no_of_decimal_places, '.', '');
		$relatedProducts[1]["final_details"]["hdnSubTotal"] = $subTotal;
		$grandTotal = $subTotal;

		$finalDiscount = $relatedProducts[1]["final_details"]["discount_amount_final"];
		if ($relatedProducts[1]["final_details"]["discount_type_final"] == "percentage") {
			$finalDiscount = ($subTotal * $relatedProducts[1]["final_details"]["discount_percentage_final"] / 100);
		}
		$finalDiscount = number_format($finalDiscount, $no_of_decimal_places, '.', '');
		$relatedProducts[1]['final_details']['discountTotal_final'] = $finalDiscount;

		$grandTotal -= $finalDiscount;                                                    //deduct final discount

		$taxtotal = '0.00';
		if ($taxType == "group") {
			$tax_details = $relatedProducts[1]['final_details']['taxes'];
			for ($tax_count = 0; $tax_count < count($tax_details); $tax_count++) {
				$tax_percent = $relatedProducts[1]['final_details']['taxes'][$tax_count]['percentage'];
				$taxamount = ($subTotal - $finalDiscount) * $tax_percent / 100;
				$taxamount = number_format($taxamount, $no_of_decimal_places, '.', '');
				$taxtotal = floatval($taxtotal) + floatval($taxamount);

				$relatedProducts[1]['final_details']['taxes'][$tax_count]['amount'] = $taxamount;

				//handle group taxes directly initialize $_REQUEST
				$tax_name = $relatedProducts[1]['final_details']['taxes'][$tax_count]['taxname'];
				$request_tax_name = $tax_name . "_group_percentage";
				$_REQUEST[$request_tax_name] = $tax_percent;
			}
		}
		$relatedProducts[1]['final_details']['tax_totalamount'] = $taxtotal;

		$grandTotal += $relatedProducts[1]['final_details']['shipping_handling_charge'];    //add shipping and handling charge
		$grandTotal += $taxtotal;                                                           //add tax total
		$grandTotal += $relatedProducts[1]['final_details']['shtax_totalamount'];           //add shipping and handling tax
		$grandTotal += $relatedProducts[1]['final_details']['adjustment'];                  //add adjustment

		$grandTotal = number_format($grandTotal, $no_of_decimal_places, '.', '');
		$relatedProducts[1]["final_details"]["grandTotal"] = $grandTotal;

		//handle S&H tax details directly initialize $_REQUEST
		$sh_tax_details = $relatedProducts[1]['final_details']['sh_taxes'];
		for ($sh_tax_count = 0; $sh_tax_count < count($sh_tax_details); $sh_tax_count++) {
			$sh_tax_name = $sh_tax_details[$sh_tax_count]['taxname'] . "_sh_percent";
			$sh_tax_percent = $sh_tax_details[$sh_tax_count]['percentage'];
			$_REQUEST[$sh_tax_name] = $sh_tax_percent;
		}

		//convert data in related products to $_REQUEST
		$requestItemFields = array(
			"deleted" => "productDeleted",
			"hdnProductId" => "hdnProductId",
			"productDescription" => "productDescription",
			"qty" => "qty",
			"listPrice" => "listPrice",
			"comment" => "comment",
			"subproduct_ids" => "subproduct_ids",
			"discount_type" => "discount_type",
			"discount_percentage" => "discount_percent",
			"discount_amount" => "discount_amount");

		foreach ($relatedProducts as $itemIdx => $itemData) {
			foreach ($requestItemFields as $requestFieldName => $itemDataFieldName) {
				$_REQUEST[$requestFieldName . $itemIdx] = $itemData[$itemDataFieldName . $itemIdx];
			}
		}

		$requestFinalFields = array(
			"taxtype" => "taxtype",
			"subtotal" => "hdnSubTotal",
			"discount_type_final" => "discount_type_final",
			"discount_percentage_final" => "discount_percentage_final",
			"discount_amount_final" => "discount_amount_final",
			"shipping_handling_charge" => "shipping_handling_charge",
			"adjustmentType" => "adjustment",
			"total" => "grandTotal"
		);

		foreach ($requestFinalFields as $requestFieldName => $itemDataFieldName) {
			if ($requestFieldName == "adjustmentType") {
				$_REQUEST["adjustmentType"] = $relatedProducts[1]["final_details"]["adjustment"] > 0 ? "" : "-";
				$_REQUEST["adjustment"] = abs($relatedProducts[1]["final_details"]["adjustment"]);
			} else {
				$_REQUEST[$requestFieldName] = $relatedProducts[1]["final_details"][$itemDataFieldName];
			}
		}

		$_REQUEST['totalProductCount'] = count($relatedProducts);
	}

	public static function saveDeliveryNotesInventoryProductDetails(&$_focus)
	{
		$adb = PearDatabase::getInstance();
		$id = $_focus->id;

		//Added to get the convertid
		if (isset($_REQUEST['convert_from']) && $_REQUEST['convert_from'] != '') {
			$id = vtlib_purify($_REQUEST['return_id']);
		} else if (isset($_REQUEST['duplicate_from']) && $_REQUEST['duplicate_from'] != '') {
			$id = vtlib_purify($_REQUEST['duplicate_from']);
		}

		if ($_focus->mode == 'edit') {
			deleteInventoryProductDetails($_focus);
		}

		$tot_no_prod = $_REQUEST['totalProductCount'];
		//If the taxtype is group then retrieve all available taxes, else retrive associated taxes for each product inside loop
		$prod_seq = 1;
		$data = array();
		for ($productIdx = 1; $productIdx <= $tot_no_prod; $productIdx++) {
			//if the product is deleted then we should avoid saving the deleted products
			if ($_REQUEST["deleted" . $productIdx] == 1)
				continue;

			$prod_id = vtlib_purify($_REQUEST['hdnProductId' . $productIdx]);
			if (isset($_REQUEST['productDescription' . $productIdx]))
				$description = vtlib_purify($_REQUEST['productDescription' . $productIdx]);

			$comment = vtlib_purify($_REQUEST['comment' . $productIdx]);

			$qty = 0;
			if ($_REQUEST["totalDistributionCount" . $productIdx] != "") {
				//if we are coming from EditView directly
				$totalDistributionCount = $_REQUEST["totalDistributionCount" . $productIdx];

				for ($distributionIdx = 1; $distributionIdx <= $totalDistributionCount; $distributionIdx++) {
					$sufix = $productIdx . "_" . $distributionIdx;
					$qty += floatval(vtlib_purify($_REQUEST['qty' . $sufix]));
				}
			} else {
				//if we are using method prepareRequestForAssociatedLineItems or prepareRequestForAssociatedProducts
				$qty = $_REQUEST["qty" . $productIdx];
			}
			//if quantity is less or equal to 0 then we will are not handling the whole line item
			//analogy to $_REQUEST["deleted".$productIdx]
			if ($qty == "" || $qty <= 0) {
				continue;
			}

			$data[$productIdx]['productid'] = $prod_id;
			$data[$productIdx]['prod_seq'] = $prod_seq++;
			$data[$productIdx]['qty'] = $qty;
			$data[$productIdx]['listprice'] = 0;
			$data[$productIdx]['comment'] = $comment;
			$data[$productIdx]['description'] = $description;
			$data[$productIdx]['subproducts'] = self::getSubProductFromRequest($productIdx);
		}

		$relations = array();
		foreach ($data as $subArr) {
            self::insertProductRel($_focus->id, $subArr['productid'], $subArr['prod_seq'], $subArr['qty'], $subArr['listprice'], $subArr['comment'], $subArr['description']);

            foreach ((array)$subArr['subproducts'] as $subProductId => $subProductQty) {
                self::insertSubProductRel($_focus->id, $subArr['prod_seq'], $subProductId, $subProductQty);
            }

			//create relation to Products
			/* @var $relationModel Vtiger_Relation_Model */
			if (!isset($relations[$subArr["productid"]])) {
				$relationModel = Vtiger_Relation_Model::getInstance(Vtiger_Module_Model::getInstance("Products"), Vtiger_Module_Model::getInstance("ITS4YouWHDeliveryNotes"));
				$relationModel->addRelation($subArr["productid"], $_focus->id);
				$relations[$subArr["productid"]] = $subArr["productid"];
			}
		}
	}

    public static function insertSubProductRel($record, $sequence, $product, $quantity = 1)
    {
        PearDatabase::getInstance()->pquery('INSERT INTO vtiger_inventorysubproductrel (id, sequence_no, productid, quantity) VALUES (?,?,?,?)',
            array($record, $sequence, $product, $quantity)
        );
    }

    public static function insertProductRel($id, $productId, $sequence, $quantity, $listPrice, $comment, $description)
    {
        PearDatabase::getInstance()->pquery('INSERT INTO vtiger_inventoryproductrel (id, productid, sequence_no, quantity, listprice, comment, description) VALUES (?,?,?,?,?,?,?)',
            array($id, $productId, $sequence, $quantity, $listPrice, $comment, $description)
        );
    }

    public static function saveParentInventoryProducts($_focus)
	{
		$adb = PearDatabase::getInstance();
		$description = '';
		$id = $_focus->id;
		//Added to get the convertid
		if (isset($_REQUEST['convert_from']) && $_REQUEST['convert_from'] != '') {
			$id = vtlib_purify($_REQUEST['return_id']);
		} else if (isset($_REQUEST['duplicate_from']) && $_REQUEST['duplicate_from'] != '') {
			$id = vtlib_purify($_REQUEST['duplicate_from']);
		}

		$ext_prod_arr = Array();
		if ($_focus->mode == 'edit') {
			if ($_REQUEST['taxtype'] == 'group')
				$all_available_taxes = getAllTaxes('available', '', 'edit', $id);

			$return_old_values = 'return_old_values';
			deleteInventoryProductDetails($_focus);
		} else {
			if ($_REQUEST['taxtype'] == 'group')
				$all_available_taxes = getAllTaxes('available', '', 'edit', $id);
		}
		$tot_no_prod = $_REQUEST['totalProductCount'];
		//If the taxtype is group then retrieve all available taxes, else retrive associated taxes for each product inside loop
		$prod_seq = 1;
		for ($i = 1; $i <= $tot_no_prod; $i++) {
			//if the product is deleted then we should avoid saving the deleted products
			if ($_REQUEST["deleted" . $i] == 1)
				continue;

			$prod_id = vtlib_purify($_REQUEST['hdnProductId' . $i]);
			if (isset($_REQUEST['productDescription' . $i]))
				$description = $_REQUEST['productDescription' . $i];

			$qty = vtlib_purify($_REQUEST['qty' . $i]);
			$listprice = vtlib_purify($_REQUEST['listPrice' . $i]);
			$comment = vtlib_purify($_REQUEST['comment' . $i]);

            self::insertProductRel($_focus->id, $prod_id, $prod_seq, $qty, $listprice, $comment, $description);

			$lineitem_id = $adb->getLastInsertID();

            $subProducts = self::getSubProductFromRequest($i);

            if (!empty($subProducts)) {
                foreach ($subProducts as $subProductId => $subProductQty) {
                    self::insertSubProductRel($_focus->id, $prod_seq, $subProductId, $subProductQty);
                }
            }

			$prod_seq++;

			$parentModule = getSalesEntityType($_focus->id);

            require_once 'modules/Emails/mail.php';

			updateStk(intval($prod_id), floatval($qty), $_focus->mode, $ext_prod_arr, $parentModule);

			//we should update discount and tax details
			$updatequery = 'UPDATE vtiger_inventoryproductrel SET ';
			$updateparams = array();

			//set the discount percentage or discount amount in update query, then set the tax values
			if ($_REQUEST['discount_type' . $i] == 'percentage') {
				$updatequery .= " discount_percent=?,";
				array_push($updateparams, $_REQUEST['discount_percentage' . $i]);
			} elseif ($_REQUEST['discount_type' . $i] == 'amount') {
				$updatequery .= " discount_amount=?,";
				$discount_amount = $_REQUEST['discount_amount' . $i];
				array_push($updateparams, $discount_amount);
			}
			if ($_REQUEST['taxtype'] == 'group') {
				for ($tax_count = 0; $tax_count < count($all_available_taxes); $tax_count++) {
					$tax_name = $all_available_taxes[$tax_count]['taxname'];

					$request_tax_name = $tax_name . "_group_percentage";
					if (isset($_REQUEST[$request_tax_name]))
						$tax_val = vtlib_purify($_REQUEST[$request_tax_name]);
					$updatequery .= " $tax_name = ?,";
					array_push($updateparams, $tax_val);
				}
				$updatequery = trim($updatequery, ',') . " where id=? and productid=? and lineitem_id = ?";
				array_push($updateparams, $_focus->id, $prod_id, $lineitem_id);
			} else {
				$taxes_for_product = getTaxDetailsForProduct($prod_id, 'all');
				for ($tax_count = 0; $tax_count < count($taxes_for_product); $tax_count++) {
					$tax_name = $taxes_for_product[$tax_count]['taxname'];
					$request_tax_name = $tax_name . "_percentage" . $i;

					$updatequery .= " $tax_name = ?,";
					array_push($updateparams, $_REQUEST[$request_tax_name]);
				}
				$updatequery = trim($updatequery, ',') . " where id=? and productid=? and lineitem_id = ?";
				array_push($updateparams, $_focus->id, $prod_id, $lineitem_id);
			}
			// jens 2006/08/19 - protect against empy update queries
			if (!preg_match('/set\s+where/i', $updatequery)) {
				$adb->pquery($updatequery, $updateparams);
			}

			//create relation to Products
			/* @var $relationModel Vtiger_Relation_Model */
			$relationModel = Vtiger_Relation_Model::getInstance(Vtiger_Module_Model::getInstance("Products"), Vtiger_Module_Model::getInstance($parentModule));
			$relationModel->addRelation($prod_id, $_focus->id);
		}

		//we should update the netprice (subtotal), taxtype, group discount, S&H charge, S&H taxes, adjustment and total
		//netprice, group discount, taxtype, S&H amount, adjustment and total to entity table

		$updatequery = " update " . $_focus->table_name . " set ";
		$updateparams = array();
		$subtotal = $_REQUEST['subtotal'];
		$updatequery .= " subtotal=?,";
		array_push($updateparams, $subtotal);

		$updatequery .= " taxtype=?,";
		array_push($updateparams, $_REQUEST['taxtype']);

		//for discount percentage or discount amount
		if ($_REQUEST['discount_type_final'] == 'percentage') {
			$updatequery .= " discount_percent=?,discount_amount=?,";
			array_push($updateparams, vtlib_purify($_REQUEST['discount_percentage_final']));
			array_push($updateparams, null);
		} elseif ($_REQUEST['discount_type_final'] == 'amount') {
			$discount_amount_final = vtlib_purify($_REQUEST['discount_amount_final']);
			$updatequery .= " discount_amount=?,discount_percent=?,";
			array_push($updateparams, $discount_amount_final);
			array_push($updateparams, null);
		} elseif ($_REQUEST['discount_type_final'] == 'zero') {
			$updatequery .= "discount_amount=?,discount_percent=?,";
			array_push($updateparams, null);
			array_push($updateparams, null);
		}

		$shipping_handling_charge = vtlib_purify($_REQUEST['shipping_handling_charge']);
		$updatequery .= " s_h_amount=?,";
		array_push($updateparams, $shipping_handling_charge);

		//if the user gave - sign in adjustment then add with the value
		$adjustmentType = '';
		if ($_REQUEST['adjustmentType'] == '-')
			$adjustmentType = vtlib_purify($_REQUEST['adjustmentType']);

		$adjustment = vtlib_purify($_REQUEST['adjustment']);
		$updatequery .= " adjustment=?,";
		array_push($updateparams, $adjustmentType . $adjustment);

		$total = vtlib_purify($_REQUEST['total']);
		$updatequery .= " total=?,";
		array_push($updateparams, $total);

		//to save the S&H tax details in vtiger_inventoryshippingrel table
		$sh_tax_details = getAllTaxes('all', 'sh');
		$sh_query_fields = "id,";
		$sh_query_values = "?,";
		$sh_query_params = array($_focus->id);
		$sh_tax_pecent = 0;
		for ($i = 0; $i < count($sh_tax_details); $i++) {
			$tax_name = $sh_tax_details[$i]['taxname'] . "_sh_percent";
			if ($_REQUEST[$tax_name] != '') {
				$sh_tax_pecent = floatval($sh_tax_pecent) + floatval(vtlib_purify($_REQUEST[$tax_name]));
				$sh_query_fields .= $sh_tax_details[$i]['taxname'] . ",";
				$sh_query_values .= "?,";
				array_push($sh_query_params, vtlib_purify($_REQUEST[$tax_name]));
			}
		}
		$sh_query_fields = trim($sh_query_fields, ',');
		$sh_query_values = trim($sh_query_values, ',');

		$updatequery .= " s_h_percent=?";
		array_push($updateparams, $sh_tax_pecent);

		//$id_array = Array('PurchaseOrder'=>'purchaseorderid','SalesOrder'=>'salesorderid','Quotes'=>'quoteid','Invoice'=>'invoiceid');
		//Added where condition to which entity we want to update these values
		$updatequery .= " where " . $_focus->table_index . "=?";
		array_push($updateparams, $_focus->id);
		$adb->pquery($updatequery, $updateparams);

		$sh_query = "INSERT INTO vtiger_inventoryshippingrel($sh_query_fields) VALUES ($sh_query_values)";
		$adb->pquery($sh_query, $sh_query_params);
	}

	/**
	 * @param $_associatedProducts
	 * @return mixed
	 */
	public static function adjustFinalDetails($_associatedProducts)
	{
		//calculate grandTotal
		$grandTotal = 0;
		foreach ($_associatedProducts as $idx => $prodData) {
			$grandTotal += $prodData["productTotal" . $idx];
		}

		$noDecPlaces = Users_Record_Model::getCurrentUserModel()->get("no_of_currency_decimals");
		$associated_prod = $_associatedProducts;
		//taxes
		$taxTotal = 0;
		foreach ($_associatedProducts[1]["final_details"]["taxes"] as $taxSeq => $taxData) {
			$taxAmount = ($taxData["percentage"] / 100) * $grandTotal;
			$taxTotal += $taxAmount;
			$associated_prod[1]["final_details"]["taxes"][$taxSeq]["amount"] = number_format($taxAmount, $noDecPlaces, ".", "");
		}
		$preTaxTotal = $grandTotal;
		$grandTotal += $taxTotal;

		$associated_prod[1]["final_details"]["shipping_handling_charge"] = number_format(0, $noDecPlaces, ".", "");
		$associated_prod[1]["final_details"]["adjustment"] = number_format(0, $noDecPlaces, ".", "");
		$associated_prod[1]["final_details"]["discount_percentage_final"] = number_format(0, $noDecPlaces, ".", "");
		$associated_prod[1]["final_details"]["discount_amount_final"] = number_format(0, $noDecPlaces, ".", "");
		$associated_prod[1]["final_details"]["discountTotal_final"] = number_format(0, $noDecPlaces, ".", "");
		$associated_prod[1]["final_details"]["shtax_totalamount"] = number_format(0, $noDecPlaces, ".", "");
		$associated_prod[1]["final_details"]["grandTotal"] = number_format($grandTotal, $noDecPlaces, ".", "");
		$associated_prod[1]["final_details"]["preTaxTotal"] = number_format($preTaxTotal, $noDecPlaces, ".", "");
		$associated_prod[1]["final_details"]["totalAfterDiscount"] = number_format($grandTotal, $noDecPlaces, ".", "");
		$associated_prod[1]["final_details"]["hdnSubTotal"] = number_format($preTaxTotal, $noDecPlaces, ".", "");
		$associated_prod[1]["final_details"]["tax_totalamount"] = number_format($taxTotal, $noDecPlaces, ".", "");

		return $associated_prod;
	}

    public static function getSubProductFromRequest($sequence)
    {
        $products = array();
        $values = array_filter(explode(',', $_REQUEST['subproduct_ids' . $sequence]));

        foreach ($values as $value) {
            $product = explode(':', $value);
            $products[$product[0]] = $product[1];
        }

        return $products;
    }
}
