<?php

/* * *******************************************************************************
 * The content of this file is subject to the MultiWarehouses4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */
require_once 'include/utils/utils.php';

class CustomInvoiceEventHandler extends VTEventHandler
{

    /**
     * @param string $handlerType
     * @param object $entityData
     * @throws Exception
     */
    public function handleEvent($handlerType, $entityData)
    {
        global $adb;

        //RELATIONSHIP
        //saving relationship between DN <=> INV
        $deliveryNotes = array();
        $parentModule = $entityData->getModuleName();

        if (isset($_REQUEST["its4youDeliveryNoteIDs"])) {
            $deliveryNotes = Zend_Json::decode(vtlib_purify($_REQUEST["its4youDeliveryNoteIDs"]));
        }

        if ('Invoice' === $parentModule && count($deliveryNotes) > 0) {
            $parentModuleModel = Vtiger_Module_Model::getInstance($entityData->getModuleName());
            $targetModuleModel = Vtiger_Module_Model::getInstance("ITS4YouWHDeliveryNotes");
            foreach ($deliveryNotes as $delNoteId) {
                $relationModel = Vtiger_Relation_Model::getInstance($parentModuleModel, $targetModuleModel);
                $relationModel->addRelation($entityData->getId(), $delNoteId);
            }

            $sql = "SELECT deliverynoteid, invoice_id, deliverynotestatus 
                    FROM its4you_deliverynotes 
                    WHERE deliverynoteid IN (" . generateQuestionMarks($deliveryNotes) . ")";
            $result = $adb->pquery($sql, $deliveryNotes);
            $fieldValues = array();
            $toBeUpdateDeliveryNotes = array();
            $delNoteId = 0;

            while ($row = $adb->fetchByAssoc($result)) {
                $delNoteId = $row["deliverynoteid"];

                if ($row["invoice_id"] == "" || $row["invoice_id"] == 0) {
                    $fieldValues["invoice_id"]["oldValue"] = $row["invoice_id"]; // no need to perform SELECT 
                    $fieldValues["invoice_id"]["currentValue"] = $entityData->getId();
                    $fieldValues["deliverynotestatus"]["oldValue"] = $row["deliverynotestatus"];   // no need to perform SELECT 
                    $fieldValues["deliverynotestatus"]["currentValue"] = "Invoiced";

                    ITS4YouWarehouses_DNUtil_ActionBlock::forceModTracker($delNoteId, "ITS4YouWHDeliveryNotes", $fieldValues);
                    $toBeUpdateDeliveryNotes[] = $delNoteId;
                }
            }
            if (count($toBeUpdateDeliveryNotes) > 0) {
                $sql2 = "UPDATE its4you_deliverynotes 
                         SET invoice_id=?, deliverynotestatus='Invoiced' 
                         WHERE deliverynoteid IN (" . generateQuestionMarks($toBeUpdateDeliveryNotes) . ")";
                $params2 = array_merge(array($entityData->getId()), $toBeUpdateDeliveryNotes);
                $adb->pquery($sql2, $params2);

                // all delivery notes relates to the same SO, thus we do not need to loop through them
                ITS4YouWarehouses_DNUtil_ActionBlock::updateRelatedSalesOrderStatus($delNoteId);
            }
        }
    }

}