<?php
/* * *******************************************************************************
 * The content of this file is subject to the MultiWarehouses4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouWarehouses_ProductsInWarehouse_Action extends Vtiger_Action_Controller
{

    /**
     * ITS4YouWarehouses_ProductsInWarehouse_Action constructor.
     */
    public function __construct()
    {
        parent::__construct();
        $this->exposeMethod('getRelatedListPageCount');
    }

    /**
     * @param Vtiger_Request $request
     * @return bool|void
     */
    public function checkPermission(Vtiger_Request $request)
    {
    }

    /**
     * @param Vtiger_Request $request
     * @return bool|void
     */
    public function preProcess(Vtiger_Request $request)
    {
        return true;
    }

    /**
     * @param Vtiger_Request $request
     * @return bool|void
     */
    public function postProcess(Vtiger_Request $request)
    {
        return true;
    }

    /**
     * @param Vtiger_Request $request
     * @throws Exception
     */
    public function process(Vtiger_Request $request)
    {
        $mode = $request->get('mode');
        if (!empty($mode)) {
            $this->invokeExposedMethod($mode, $request);
            return;
        }
    }

    /**
     * @param Vtiger_Request $request
     */
    public function getRelatedListPageCount(Vtiger_Request $request)
    {
        $parentId = $request->get('record');
        $pagingModel = new Vtiger_Paging_Model();

        $listViewModel = new ITS4YouWarehouses_ProductsInWarehouseListView_Model(array("warehouseid" => $parentId));

        $searchParams = $request->get('search_params');
        if (empty($searchParams)) {
            $searchParams = array();
        }
        $transformedSearchParams = Vtiger_Util_Helper::transferListSearchParamsToFilterCondition($searchParams, Vtiger_Module_Model::getInstance("ITS4YouWarehouses"));
        $listViewModel->set('search_params', $transformedSearchParams);

        $totalCount = $listViewModel->getRelatedEntriesCount();
        $pageLimit = $pagingModel->getPageLimit();
        $pageCount = ceil((int)$totalCount / (int)$pageLimit);

        if ($pageCount == 0) {
            $pageCount = 1;
        }
        $result = array();
        $result['numberOfRecords'] = $totalCount;
        $result['page'] = $pageCount;

        $response = new Vtiger_Response();
        $response->setResult($result);
        $response->emit();
    }

    /**
     * @param Vtiger_Request $request
     * @return bool|void
     * @throws Exception
     */
    public function validateRequest(Vtiger_Request $request)
    {
        $request->validateWriteAccess();
    }

}
