<?php
/* ********************************************************************************
 * The content of this file is subject to the ITS4YouWarehouses license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouWarehouses_InventoryDelete_Action extends Vtiger_Action_Controller
{

    /**
     * @param Vtiger_Request $request
     * @throws AppException
     */
    public function checkPermission(Vtiger_Request $request)
    {
        $moduleName = $request->getModule();
        $record = $request->get('record');

        $currentUserPrivilegesModel = Users_Privileges_Model::getCurrentUserPrivilegesModel();
        if (!$currentUserPrivilegesModel->isPermitted($moduleName, 'Delete', $record)) {
            throw new AppException(vtranslate('LBL_PERMISSION_DENIED'));
        }

        if (!$currentUserPrivilegesModel->isAdminUser()) {
            $recordModel = Vtiger_Record_Model::getInstanceById($record, $moduleName);

            ITS4YouWarehouses_SeqStatusActionHandler_Helper::checkStatusPermission($moduleName, $recordModel->get(ITS4YouWarehouses_Util_Helper::getStatusField($moduleName)));
        }
    }

    /**
     * @param Vtiger_Request $request
     * @throws AppException
     */
    public function process(Vtiger_Request $request)
    {
        $moduleName = $request->getModule();
        $recordId = $request->get('record');
        $recordModel = Vtiger_Record_Model::getInstanceById($recordId, $moduleName);
        $recordModel->delete();

        if ('DeleteAjax' === $request->get('action')) {
            $response = new Vtiger_Response();
            $response->setResult(array('viewname' => $request->get('viewname'), 'module' => $moduleName));
            $response->emit();
        } else {
            $ajaxDelete = $request->get('ajaxDelete');
            $moduleModel = $recordModel->getModule();
            $listViewUrl = $moduleModel->getListViewUrl();

            if ($ajaxDelete) {
                $response = new Vtiger_Response();
                $response->setResult($listViewUrl);
                $response->emit();
            } else {
                header("Location: $listViewUrl");
            }
        }
    }

    /**
     * @param Vtiger_Request $request
     * @throws Exception
     */
    public function validateRequest(Vtiger_Request $request)
    {
        $request->validateWriteAccess();
    }
}
