<?php

/* * *******************************************************************************
 * The content of this file is subject to the MultiWarehouses4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouWarehouses_RCUtil_ActionBlock
{

    /**
     * Update status of Purchase Order related to Delivery Note
     * @param int $_receiptCardId
     * @throws Exception
     * @global PearDatabase $adb
     */
    public static function updateRelatedPurchaseOrderStatus($_receiptCardId)
    {
        global $adb;

        $purchaseOrderIds = self::getRelatedPurchaseOrders($_receiptCardId);

        foreach ($purchaseOrderIds as $purchaseOrderId => $oldStatus) {
            $actionBlock = ITS4YouWarehouses_Base_ActionBlock::factory("PurchaseOrder", $purchaseOrderId);
            $newStatus = "";
            //if all items of related PO are Receipted from Vendor then set status of PO to Received Shipment
            if ($actionBlock->isCompletelyReceivedShipment()) {
                $newStatus = "Received Shipment";
            } elseif ($oldStatus == "Received Shipment") {  // else if current PO status is Received Shipment then change it to Delivered
                $newStatus = "Delivered";
            }

            if ($newStatus != "") {
                $sql = "UPDATE vtiger_purchaseorder SET postatus = ? WHERE purchaseorderid = ?";
                $adb->pquery($sql, array($newStatus, $purchaseOrderId));
            }
        }
    }

    public static function getRelatedPurchaseOrders($_receiptCardId)
    {
        global $adb;

        $sql = "SELECT  vtiger_purchaseorder.purchaseorderid,
                        vtiger_purchaseorder.postatus
                FROM vtiger_purchaseorder
                INNER JOIN vtiger_crmentityrel
                    ON vtiger_purchaseorder.purchaseorderid = vtiger_crmentityrel.crmid
                INNER JOIN vtiger_crmentity
                    ON vtiger_purchaseorder.purchaseorderid = vtiger_crmentity.crmid                
                WHERE vtiger_crmentity.deleted = 0
                  AND vtiger_crmentityrel.module = 'PurchaseOrder'
                  AND vtiger_crmentityrel.relmodule = 'ITS4YouReceiptcards'
                  AND vtiger_crmentityrel.relcrmid = ?";
        $result = $adb->pquery($sql, array($_receiptCardId));
        $purchaseOrderIds = array();
        if ($adb->num_rows($result) > 0) {
            while ($row = $adb->fetchByAssoc($result)) {
                $purchaseOrderIds[$row["purchaseorderid"]] = $row["postatus"];
            }
        }

        return $purchaseOrderIds;
    }

}
