<?php
/* * *******************************************************************************
 * The content of this file is subject to the MultiWarehouses4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

/**
 * Class ITS4YouWarehouses_RC_ActionBlock
 */
class ITS4YouWarehouses_RC_ActionBlock extends ITS4YouWarehouses_Base_ActionBlock implements ITS4YouWarehouses_IStatusActionBlock_Sequential
{

    /**
     * @var
     */
    private $receiptcardstatus;
    /**
     * @var
     */
    private $vendor_id;
    /**
     * @var
     */
    private $receiptcardtype;

    /**
     * ITS4YouWarehouses_RC_ActionBlock constructor.
     * @param $_parentId
     * @throws Exception
     */
    public function __construct($_parentId)
    {
        parent::__construct($_parentId);

        $this->readParrentAttributes();
        $this->processReturnedProducts();
    }

    /**
     * @throws Exception
     */
    private function readParrentAttributes()
    {
        global $adb;

        $sql = "SELECT receiptcardstatus, vendorid, receiptcardtype
                FROM its4you_receiptcards
                WHERE receiptcardid=?";
        $result = $adb->pquery($sql, array($this->parentId));
        if ($adb->num_rows($result) > 0) {
            $this->receiptcardstatus = $adb->query_result($result, 0, "receiptcardstatus");
            $this->vendor_id = $adb->query_result($result, 0, "vendorid");
            $this->receiptcardtype = $adb->query_result($result, 0, "receiptcardtype");
        }
    }

    /**
     * @throws Exception
     */
    private function processReturnedProducts()
    {
        $this->getLineItems();

        if ($this->receiptcardtype == "Warehouse transfer") {
            $relatedWarehouseTransfers = $this->getReturnProductsWT();
            CrossInventoryRelEventHandler::addCrossInventoryRels($this->lineItems, array_keys($relatedWarehouseTransfers));
        } else {
            $relatedIssuecards = $this->getRelatedIssuecards(array("Transferred from Warehouse", "Delivered"));
            CrossInventoryRelEventHandler::addCrossInventoryRels($this->lineItems, array_keys($relatedIssuecards));
        }

        foreach ($this->lineItems as $lineItem) {
            $item = $this->getItem($lineItem->getProductId());
            if ($item === null) {
                continue;
            }

            $returnedQty = $item->getStatusQty(ITS4YouWarehouses_ItemStatus_ActionBlock::STATUS_RETURNED);
            $returnedQty += $lineItem->getQuantity() - $lineItem->getAdjustedQuantity();

            $item->modifyExplicitStatus(ITS4YouWarehouses_ItemStatus_ActionBlock::STATUS_RETURNED, $returnedQty);
        }
    }

    /**
     * Only for RC which is type of Warehouse transfer. Returns those WT which were created via Return Products action
     * @return array of WTs
     */
    private function getReturnProductsWT()
    {
        $db = PearDatabase::getInstance();

        $statuses = array("Transferred from Warehouse", "Delivered");
        $sql = "SELECT vtiger_crmentityrel.relcrmid, its4you_warehousetransfers.warehousetransfer_no
                FROM vtiger_crmentityrel
                INNER JOIN vtiger_crmentity
                    ON vtiger_crmentity.crmid = vtiger_crmentityrel.relcrmid
                INNER JOIN its4you_warehousetransfers
                    ON its4you_warehousetransfers.warehousetransferid = vtiger_crmentityrel.relcrmid
                WHERE vtiger_crmentity.deleted = 0
                    AND vtiger_crmentityrel.crmid=? 
                    AND vtiger_crmentityrel.module=? 
                    AND vtiger_crmentityrel.relmodule=?
                    AND vtiger_crmentityrel.relcrmid != ?
                    AND its4you_warehousetransfers.wtstatus IN (" . generateQuestionMarks($statuses) . ")";
        $params = array_merge(array($this->parentId, "ITS4YouReceiptcards", "ITS4YouWarehouseTransfers", $this->vendor_id), $statuses);
        $result = $db->pquery($sql, $params);
        $warehouseTransfers = array();
        if ($db->num_rows($result) > 0) {
            while ($row = $db->fetchByAssoc($result)) {
                $warehouseTransfers[$row["relcrmid"]] = $row["warehousetransfer_no"];
            }
        }

        return $warehouseTransfers;
    }

    /**
     * @param $_statuses
     * @return array
     */
    private function getRelatedIssuecards($_statuses)
    {
        $db = PearDatabase::getInstance();

        $sql = "SELECT vtiger_crmentityrel.relcrmid, its4you_issuecards.issuecards_no
                FROM vtiger_crmentityrel 
                INNER JOIN vtiger_crmentity
                    ON vtiger_crmentity.crmid=vtiger_crmentityrel.relcrmid
                INNER JOIN its4you_issuecards
                    ON vtiger_crmentity.crmid=its4you_issuecards.issuecardid
                WHERE vtiger_crmentity.deleted = 0 
                    AND vtiger_crmentityrel.crmid=? 
                    AND vtiger_crmentityrel.module=? 
                    AND vtiger_crmentityrel.relmodule=?
                    AND its4you_issuecards.issuecardstatus IN (" . generateQuestionMarks($_statuses) . ")";
        $params = array_merge(array($this->parentId, "ITS4YouReceiptcards", "ITS4YouIssuecards"), $_statuses);
        $result = $db->pquery($sql, $params);
        $receiptCards = array();
        if ($db->num_rows($result) > 0) {
            while ($row = $db->fetchByAssoc($result)) {
                $receiptCards[$row["relcrmid"]] = $row["issuecards_no"];
            }
        }

        return $receiptCards;
    }

    /**
     * @return array
     * @throws Exception
     */
    public function getSeqStatusViewModel()
    {
        $actions = array();
        $moduleName = "ITS4YouWHDeliveryNotes";

        switch ($this->receiptcardstatus) {
            case "Created":
                $actions[] = array(
                    "url" => "javascript: void(0);",
                    "label" => vtranslate("LBL_RECEIVE_PRODUCTS", $moduleName),
                    "class" => "btn-success action" . ITS4YouWarehouses_RCStatusPool_Sequential::ACTION_MODE_DELIVER
                );
                break;

            case "Delivered":
                if ($this->receiptcardtype === "From supplier" || $this->receiptcardtype === "Warehouse transfer") {
                    $actions[] = array(
                        "url" => "javascript: ITS4YouUtils_Js.returnProducts(\'ITS4YouReceiptcards\', \'" . $this->parentId . "\');",
                        "label" => vtranslate("LBL_RETURN_PRODUCTS", $moduleName),
                        "class" => "btn-info action"
                    );
                }
                break;
        }
        if ($this->receiptcardstatus != "Canceled") {
            $actions[] = array(
                "url" => "javascript: void(0);",
                "label" => vtranslate("LBL_CANCEL_RC", $moduleName),
                "class" => "btn-warning action" . ITS4YouWarehouses_RCStatusPool_Sequential::ACTION_MODE_CANCEL
            );
        }

        $seqStatusInstance = ITS4YouWarehouses_RCStatusPool_Sequential::getInstance()->getFirst();
        /* @var $seqStatusInstance ITS4YouWarehouses_IStatus_Sequential */
        $sequentialStatuses = array();
        while ($seqStatusInstance != null) {
            if ($this->receiptcardstatus != "Canceled") {
                if ($seqStatusInstance->getId() != "Canceled") {
                    $sequentialStatuses[$seqStatusInstance->getId()] = $this->receiptcardstatus == $seqStatusInstance->getId();
                }
            } else {
                $sequentialStatuses[$seqStatusInstance->getId()] = $this->receiptcardstatus == $seqStatusInstance->getId();
                if ($seqStatusInstance->getId() == $this->getPreCanceledStatus()) {
                    $sequentialStatuses["Canceled"] = true;
                    break;
                }
            }
            $seqStatusInstance = $seqStatusInstance->getNext();
        }

        return array(
            "actions" => $actions,
            "sequential_statuses" => $sequentialStatuses
        );
    }

    /**
     * @return mixed|null
     * @throws Exception
     */
    private function getPreCanceledStatus()
    {
        global $adb;
        if (!file_exists("modules/ModTracker/ModTracker.php")) {
            return null;
        }
        require_once "modules/ModTracker/ModTracker.php";
        // modifiedtime could be better for performance but Edit must be disabled once the DN is canceled
        $sql = "SELECT createdtime FROM vtiger_crmentity WHERE crmid = ?";
        $result = $adb->pquery($sql, array($this->parentId));
        $time = $adb->query_result($result, 0, "createdtime");
        $fieldChanges = ModTracker::getRecordFieldChanges($this->parentId, strtotime($time));

        if (isset($fieldChanges["receiptcardstatus"]) && $fieldChanges["receiptcardstatus"]["postvalue"] == "Canceled") {
            return $fieldChanges["receiptcardstatus"]["prevalue"];
        } else {
            return null;
        }
    }

    /**
     * @return array
     */
    public function getChangeStatusDeliverViewModel()
    {
        $disabled = "false";
        $entityType = getSalesEntityType($this->vendor_id);
        if ($entityType === "ITS4YouWarehouseTransfers" || $entityType === "ITS4YouIssuecards" || $this->receiptcardtype == "Products return") {
            $disabled = "true";
        }

        $items = array();
        foreach ($this->lineItems as $lineItemId => $lineItem) {
            /* @var $lineItem ITS4YouWarehouses_InventoryLineItem_Helper */
            if ($lineItem->getParentId() != $this->parentId) {
                continue;
            }
            $items[$lineItemId]["name"] = $lineItem->getName();
            $items[$lineItemId]["parent_qty"] = self::formatNumberForEditView($lineItem->getQuantity());
            $items[$lineItemId]["disabled"] = $disabled;
        }

        return array(
            "items" => $items,
            "title" => vtranslate("LBL_RECEIVE_PRODUCTS", "ITS4YouWHDeliveryNotes"),
            "qty_col_title" => vtranslate("HEAD_RECEIVE_QTY", "ITS4YouWHDeliveryNotes")
        );
    }

    /**
     * @return array
     */
    public function getReturnProductsViewModel()
    {
        return [
            'items' => $this->getReturnProductsLineItems(),
            'isReturnable' => $this->isReturnable,
            'target_module' => ('Warehouse transfer' === $this->receiptcardtype) ? 'ITS4YouWarehouseTransfers' : 'ITS4YouIssuecards',
        ];
    }

    /**
     * @return array
     */
    public function getReturnProductsIssuecards()
    {
        $relatedIssuecards = array();
        if ($this->receiptcardtype != "Warehouse transfer") {
            $relatedIssuecards = $this->getRelatedIssuecards(array("Transferred from Warehouse", "Delivered"));
        }
        return $relatedIssuecards;
    }

}
