<?php

/* * *******************************************************************************
 * The content of this file is subject to the MultiWarehouses4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouWarehouses_PO_ActionBlock extends ITS4YouWarehouses_Base_ActionBlock
{

    private $postatus;

    /**
     * ITS4YouWarehouses_PO_ActionBlock constructor.
     * @param number $_parentId
     * @throws Exception
     */
    protected function __construct($_parentId)
    {
        parent::__construct($_parentId);

        $this->readParentAttributes();
        $this->getLineItems();
        $this->processRelatedReceiptCards();
    }

    /**
     * @throws Exception
     */
    private function readParentAttributes()
    {
        global $adb;

        $sql = "SELECT postatus FROM vtiger_purchaseorder WHERE purchaseorderid = ?";
        $result = $adb->pquery($sql, array($this->parentId));

        $this->postatus = $adb->query_result($result, 0, "postatus");
    }

    /**
     * @throws Exception
     */
    private function processRelatedReceiptCards()
    {
        $relatedReceiptCardIDs = $this->getRelatedReceiptCards(array("Delivered"));
        if (count($relatedReceiptCardIDs) <= 0) {
            return;
        }

        CrossInventoryRelEventHandler::addCrossInventoryRels($this->lineItems, array_keys($relatedReceiptCardIDs));

        /* @var ITS4YouWarehouses_InventoryLineItem_Helper $lineItem */
        foreach ($this->lineItems as $lineItem) {
            $item = $this->getItem($lineItem->getProductId());
            if ($item !== null) {
                $receiptedQty = $item->getStatusQty(ITS4YouWarehouses_ItemStatus_ActionBlock::STATUS_RECEIPTED) + $lineItem->getQuantity() - $lineItem->getAdjustedQuantity();
                $item->modifyExplicitStatus(ITS4YouWarehouses_ItemStatus_ActionBlock::STATUS_RECEIPTED, $receiptedQty);
            }
        }
    }

    private function getRelatedReceiptCards($_statuses)
    {
        global $adb;

        $sql = "SELECT vtiger_crmentityrel.relcrmid, its4you_receiptcards.receiptcards_no
                FROM vtiger_crmentityrel 
                INNER JOIN vtiger_crmentity
                    ON vtiger_crmentity.crmid=vtiger_crmentityrel.relcrmid
                INNER JOIN its4you_receiptcards
                    ON vtiger_crmentity.crmid=its4you_receiptcards.receiptcardid
                WHERE vtiger_crmentity.deleted = 0 
                    AND vtiger_crmentityrel.crmid=? 
                    AND vtiger_crmentityrel.module=? 
                    AND vtiger_crmentityrel.relmodule=?
                    AND its4you_receiptcards.receiptcardstatus IN (" . generateQuestionMarks($_statuses) . ")";
        $params = array_merge(array($this->parentId, "PurchaseOrder", "ITS4YouReceiptcards"), $_statuses);
        $result = $adb->pquery($sql, $params);
        $receiptCardsIDs = array();
        if ($adb->num_rows($result) > 0) {
            while ($row = $adb->fetchByAssoc($result)) {
                $receiptCardsIDs[$row["relcrmid"]] = $row["receiptcards_no"];
            }
        }

        return $receiptCardsIDs;
    }

    public function isCanceled()
    {
        return ($this->postatus === "Cancelled");
    }

    public function getOverviewModel($_selectedProducts)
    {
        //in order to avoid passing $_selectedProducts through all methods chain
        //we will use workaround so $this->items will contains only those in $_selectedProducts
        $parentItems = $this->getItems();
        foreach ($parentItems as $itemId => $item) {
            if (!in_array($itemId, $_selectedProducts)) {
                $this->removeItem($itemId);
            }
        }

        $mainViewModel = $this->getMainViewModel();

        $buttons = array(
            "product_col" => array(false),
            "ordered_col" => array(ITS4YouWarehouses_ItemStatus_ActionBlock::STATUS_AWAITING),
            "receipted_col" => array(false)
        );

        //adjust viewmodel so it contains another dimension for actions in delivery overview block 
        foreach ($buttons as $column => $statuses) {
            foreach ($statuses as $statusId) {
                if ($statusId !== false && isset($mainViewModel["actions"][$statusId])) {
                    $mainViewModel["overviewActions"][$column] = $mainViewModel["actions"][$statusId][0];
                    break;
                } else {
                    $mainViewModel["overviewActions"][$column] = "";
                }
            }
        }

        //provide smarty template name
        $mainViewModel["overviewTemplate"] = "POActionBlockOverview.tpl";

        return $mainViewModel;
    }

    public function getMainViewModel()
    {
        $viewModel = parent::getMainViewModel();
        $viewModel["overview"] = array(
            "title" => vtranslate("LBL_DISPLAY_OVERVIEW_TITLE_PO", "ITS4YouWHDeliveryNotes"),
            "label" => vtranslate("LBL_DISPLAY_OVERVIEW_PO", "ITS4YouWHDeliveryNotes")
        );
//        $viewModel["template"] = "POActionBlock.tpl";

        return $viewModel;
    }

    // New version of method, which is written as a bridge between old way of handling adjusted line items and new version

    /**
     * @param array $_selectedProducts
     * @return array
     * @throws AppException
     */
    public function getWaitingAvailabilityActionViewModel($_selectedProducts)
    {
        $items = array();
        $lineItems = $this->getToBeReceiptedLineItems();
        /* @var $lineItem ITS4YouWarehouses_InventoryLineItem_Helper */
        foreach ($lineItems as $lineItemId => $lineItem) {
            $productId = $lineItem->getProductId();
            if (!in_array($productId, $_selectedProducts)) {
                continue;
            }

            $item = $this->getItem($productId);
            $items[$lineItemId]["productid"] = $productId;
            $items[$lineItemId]["name"] = $item->getName();
            $items[$lineItemId]["receipt_date"] = getNewDisplayDate();
            $items[$lineItemId]["price"] = self::formatNumberForEditView($lineItem->getPrice());
            $items[$lineItemId]["toreceipt_qty"] = self::formatNumberForEditView($lineItem->getQuantity());
        }

        $listViewModel = Vtiger_ListView_Model::getInstance("ITS4YouWarehouses");
        $pagingModel = new Vtiger_Paging_Model();
        $pagingModel->set("limit", 1000);
        $listViewEntries = $listViewModel->getListViewEntries($pagingModel);
        foreach ($listViewEntries as $recordId => $listViewRecordModel) {
            $other["warehouses"][$recordId] = $listViewRecordModel->get("warehouse_name");
        }

        $other["user_date_format"] = Users_Record_Model::getCurrentUserModel()->get("date_format");
        return array("items" => $items, "other" => $other);
    }

    public function getToBeReceiptedLineItems()
    {
        $adjustedLineItems = array();
        foreach ($this->lineItems as $lineItemId => $lineItem) {
            if ($lineItem->getAdjustedQuantity() > 0) {
                $lineItemClone = clone $lineItem;
                $lineItemClone->setQuantity($lineItemClone->getAdjustedQuantity());
                $adjustedLineItems[$lineItemId] = $lineItemClone;
            }
        }

        return $adjustedLineItems;
    }

    /**
     * Process all items of check whether they are completely received shipment
     * @return bool
     */
    public function isCompletelyReceivedShipment()
    {
        /* @var $item ITS4YouWarehouses_Item_ActionBlock */
        $parentItems = $this->getItems();
        foreach ($parentItems as $item) {
            if ($item->getStatusQty(ITS4YouWarehouses_ItemStatus_ActionBlock::STATUS_AWAITING) > 0) {
                return false;
            }
        }
        return true;
    }

    public function getRelatedSalesOrders()
    {
        global $adb;

        $sql = "SELECT vtiger_crmentityrel.crmid
                FROM vtiger_crmentityrel 
                INNER JOIN vtiger_crmentity
                    ON vtiger_crmentity.crmid=vtiger_crmentityrel.crmid                
                WHERE vtiger_crmentity.deleted = 0 
                    AND vtiger_crmentityrel.module=? 
                    AND vtiger_crmentityrel.relcrmid=?                     
                    AND vtiger_crmentityrel.relmodule=?";

        $result = $adb->pquery($sql, array("SalesOrder", $this->parentId, "PurchaseOrder"));
        $salesOrderIds = array();
        if ($adb->num_rows($result) > 0) {
            while ($row = $adb->fetchByAssoc($result)) {
                $salesOrderIds[] = $row["crmid"];
            }
        }

        return $salesOrderIds;
    }

    protected function createParentItems()
    {
        global $adb;

        $sql = "SELECT  CASE WHEN vtiger_products.productid != '' THEN vtiger_products.productname ELSE vtiger_service.servicename END AS 'productname',
                        CASE WHEN vtiger_products.productid != '' THEN vtiger_products.qtyinstock ELSE '0' END AS 'available_qty',            
                        " . ITS4YouWarehouses_ItemInfo_ActionBlock::getItemInfoQuery() . ",
                        parent_rel.productid,           
                        SUM(parent_rel.quantity) AS parent_qty,
                        vtiger_crmentity.setype
                FROM vtiger_inventoryproductrel AS parent_rel
                INNER JOIN vtiger_crmentity
                    ON vtiger_crmentity.crmid=parent_rel.productid
                LEFT JOIN vtiger_products
                    ON vtiger_products.productid=parent_rel.productid                                
                LEFT JOIN vtiger_service
                    ON vtiger_service.serviceid=parent_rel.productid                  
                WHERE vtiger_crmentity.deleted = 0 
                    AND parent_rel.id=?                 
                GROUP BY parent_rel.productid 
                ORDER BY parent_rel.sequence_no";
        $result = $adb->pquery($sql, array($this->parentId));
        if ($adb->num_rows($result) > 0) {
            while ($row = $adb->fetchByAssoc($result)) {
                $parentItem = new ITS4YouWarehouses_ItemInbound_ActionBlock($row["productid"], $row["productname"], $this->parentId, $row["parent_qty"], $row["available_qty"], ITS4YouWarehouses_ItemInfo_ActionBlock::initialize($row), $row["setype"]);
                $this->addItem($parentItem);
            }
        }
    }

}