<?php
/* * *******************************************************************************
 * The content of this file is subject to the MultiWarehouses4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

/**
 * Represent general information about action block item (product or service)
 */
class ITS4YouWarehouses_ItemInfo_ActionBlock
{

    /** @var array */
    private static $column2property = array(
        "unit_price" => "unitPrice",
        "vendor_id" => "vendorId",
        "reorderlevel" => "reorderLevel",
        'optimallevel' => 'optimalLevel',
        'purchase_cost' => 'purchaseCost',
    );

    /**
     * @var int
     */
    private $unitPrice;

    /**
     * @var int
     */
    private $vendorId;

    /**
     * @var int
     */
    private $reorderLevel;

    /**
     * @var int
     */
    private $optimalLevel;

    /**
     * @var float
     */
    private $purchaseCost;

    /**
     * @param $_dbRow
     * @return ITS4YouWarehouses_ItemInfo_ActionBlock
     */
    public static function initialize($_dbRow)
    {
        $instance = new ITS4YouWarehouses_ItemInfo_ActionBlock();
        $instance->setData($_dbRow);

        return $instance;
    }

    /**
     * @param array $data
     */
    public function setData($data)
    {
        foreach (self::$column2property as $dbColumn => $classProperty) {
            if (isset($data[$dbColumn]) && property_exists(get_class(), $classProperty)) {
                $this->set($classProperty, $data[$dbColumn]);
            }
        }
    }

    /**
     * @param string $name
     * @param mixed $value
     */
    public function set($name, $value)
    {
        $this->$name = $value;
    }

    /**
     * @return string
     */
    public static function getItemInfoQuery()
    {
        $query = " CASE WHEN vtiger_products.productid != '' THEN vtiger_products.unit_price ELSE vtiger_service.unit_price END AS unit_price,";
        $query .= "CASE WHEN vtiger_products.productid != '' THEN vtiger_products.vendor_id ELSE '0' END AS vendor_id,";
        $query .= "CASE WHEN vtiger_products.productid != '' THEN vtiger_products.reorderlevel ELSE '0' END AS reorderlevel,";
        $query .= "CASE WHEN vtiger_products.productid != '' THEN vtiger_products.purchase_cost ELSE '0' END AS purchase_cost,";
        $query .= "CASE WHEN vtiger_products.productid != '' THEN vtiger_products.optimallevel ELSE '0' END AS optimallevel";

        return $query;
    }

    /**
     * @return mixed
     */
    public function getUnitPrice()
    {
        return $this->unitPrice;
    }

    /**
     * @return float
     */
    public function getPurchaseCost()
    {
        return $this->purchaseCost;
    }

    /**
     * @return mixed
     */
    public function getVendorId()
    {
        return $this->vendorId;
    }

    /**
     * @return int
     */
    public function getReorderLevel()
    {
        return intval($this->reorderLevel);
    }

    /**
     * @return int
     */
    public function getOptimalLevel()
    {
        return intval($this->optimalLevel);
    }

}