<?php
/* * *******************************************************************************
 * The content of this file is subject to the MultiWarehouses4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouWarehouses_INVStatusActionsPool_ActionBlock extends ITS4YouWarehouses_StatusActionsPoolBase_ActionBlock
{
    /* @var $instance ITS4YouWarehouses_INVStatusActionsPool_ActionBlock */

    private static $instance = null;

    protected function __construct()
    {
        parent::__construct();
    }

    /**
     * @return ITS4YouWarehouses_INVStatusActionsPool_ActionBlock|ITS4YouWarehouses_StatusActionsPoolBase_ActionBlock|null
     */
    public static function getInstance()
    {
        if (self::$instance == null) {
            self::$instance = new ITS4YouWarehouses_INVStatusActionsPool_ActionBlock();
        }
        return self::$instance;
    }

    /**
     *
     */
    protected function initStatusActions()
    {
        parent::initStatusActions();

        //override INVOICED status action - change label
        $this->setStatusAction(ITS4YouWarehouses_ItemStatus_ActionBlock::STATUS_INVOICED, new ITS4YouWarehouses_ItemStatusActionViewModel_Helper(ITS4YouWarehouses_ItemStatus_ActionBlock::STATUS_INVOICED, 'actionShowOverview'));

        //override TOBEINVOICED status action - remove button
        $actionViewModel = new ITS4YouWarehouses_ItemStatusActionViewModel_Helper(ITS4YouWarehouses_ItemStatus_ActionBlock::STATUS_TOBEINVOICED, 'actionShowOverview');
        $this->setStatusAction(ITS4YouWarehouses_ItemStatus_ActionBlock::STATUS_TOBEINVOICED, $actionViewModel);
    }

}