<?php
/* * *******************************************************************************
 * The content of this file is subject to the MultiWarehouses4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

/**
 * Class ITS4YouWarehouses_IC_ActionBlock
 */
class ITS4YouWarehouses_IC_ActionBlock extends ITS4YouWarehouses_Base_ActionBlock implements ITS4YouWarehouses_IStatusActionBlock_Sequential
{

    /**
     * @var
     */
    private $issuecardstatus;
    /**
     * @var
     */
    protected $deliverynoteid;
//    protected $lineItems;
    /**
     * @var
     */
    protected $adjustedLineItemsAfterReturn;
    /**
     * @var
     */
    protected $warehouseId;

    /**
     * ITS4YouWarehouses_IC_ActionBlock constructor.
     * @param $_parentId
     * @throws Exception
     */
    public function __construct($_parentId)
    {
        parent::__construct($_parentId);

        $this->readParrentAttributes();
    }

    /**
     * @throws Exception
     */
    protected function readParrentAttributes()
    {
        global $adb;

        $sql = "SELECT issuecardstatus, parent_id, warehouseid
                FROM its4you_issuecards
                WHERE issuecardid=?";
        $result = $adb->pquery($sql, array($this->parentId));
        if ($adb->num_rows($result) > 0) {
            $this->issuecardstatus = $adb->query_result($result, 0, "issuecardstatus");
            $this->deliverynoteid = $adb->query_result($result, 0, "parent_id");
            $this->warehouseId = $adb->query_result($result, 0, "warehouseid");
        }
    }

    /**
     * @return mixed
     */
    public function getWarehouseId()
    {
        return $this->warehouseId;
    }

    /**
     * @throws Exception
     */
    public function getChangeStatusDeliverViewModel()
    {
        throw new Exception("MultiWarehouses4You :: Not implemented.");
    }

    /**
     * @return array
     * @throws Exception
     */
    public function getSeqStatusViewModel()
    {
        $actions = array();
        $moduleName = "ITS4YouIssuecards";

        if ($this->issuecardstatus != "Canceled") {
            if (empty($this->deliverynoteid) && $this->issuecardstatus != "Created" && $this->issuecardstatus != "Approved") {
                $actions[] = array(
                    "url" => "javascript: ITS4YouUtils_Js.returnProducts(\'" . $moduleName . "\', \'" . $this->parentId . "\');",
                    "label" => vtranslate("LBL_RETURN_PRODUCTS", $moduleName),
                    "class" => "btn-info action"
                );
            }

            $actions[] = array(
                "url" => "javascript: void(0);",
                "label" => vtranslate("LBL_CANCEL_IC", $moduleName),
                "class" => "btn-warning action" . ITS4YouWarehouses_ICStatusPool_Sequential::ACTION_MODE_CANCEL
            );
        }

        $seqStatusInstance = ITS4YouWarehouses_ICStatusPool_Sequential::getInstance()->getFirst();
        /* @var $seqStatusInstance ITS4YouWarehouses_IStatus_Sequential */
        $sequentialStatuses = array();
        while ($seqStatusInstance != null) {
            if ($this->issuecardstatus != "Canceled") {
                if ($seqStatusInstance->getId() != "Canceled") {
                    $sequentialStatuses[$seqStatusInstance->getId()] = $this->issuecardstatus == $seqStatusInstance->getId();
                }
            } else {
                $sequentialStatuses[$seqStatusInstance->getId()] = $this->issuecardstatus == $seqStatusInstance->getId();
                if ($seqStatusInstance->getId() == $this->getPreCanceledStatus()) {
                    $sequentialStatuses["Canceled"] = true;
                    break;
                }
            }
            $seqStatusInstance = $seqStatusInstance->getNext();
        }

        return array(
            "actions" => $actions,
            "sequential_statuses" => $sequentialStatuses
        );
    }

    /**
     * @return mixed|null
     * @throws Exception
     */
    protected function getPreCanceledStatus()
    {
        global $adb;
        if (!file_exists("modules/ModTracker/ModTracker.php")) {
            return null;
        }
        require_once "modules/ModTracker/ModTracker.php";
        // modifiedtime could be better for performance but Edit must be disabled once the IC is canceled
        $sql = "SELECT createdtime FROM vtiger_crmentity WHERE crmid = ?";
        $result = $adb->pquery($sql, array($this->parentId));
        $time = $adb->query_result($result, 0, "createdtime");
        $fieldChanges = ModTracker::getRecordFieldChanges($this->parentId, strtotime($time));

        if (isset($fieldChanges["issuecardstatus"]) && $fieldChanges["issuecardstatus"]["postvalue"] == "Canceled") {
            return $fieldChanges["issuecardstatus"]["prevalue"];
        } else {
            return null;
        }
    }

    /**
     * @return array
     */
    public function getReturnProductsViewModel()
    {
        return [
            'items' => $this->getReturnProductsLineItems($this->getLineItems()),
            'isReturnable' => $this->isReturnable,
            'target_module' => 'ITS4YouReceiptcards',
        ];
    }

    /**
     * @return array
     */
    public function getLineItems()
    {
        if (empty($this->lineItems)) {
            $this->lineItems = ITS4YouWarehouses_InventoryLineItem_Helper::getParentLineItems($this->parentId);
            $relatedReceiptCards = $this->getRelatedReceiptcards(array("Created", "Delivered"));
            CrossInventoryRelEventHandler::addCrossInventoryRels($this->lineItems, array_keys($relatedReceiptCards));
        }

        return $this->lineItems;
    }

    /**
     * @param $_statuses
     * @return array
     */
    protected function getRelatedReceiptcards($_statuses)
    {
        $db = PearDatabase::getInstance();

        $sql = "SELECT vtiger_crmentityrel.relcrmid, its4you_receiptcards.receiptcards_no
                FROM vtiger_crmentityrel 
                INNER JOIN vtiger_crmentity
                    ON vtiger_crmentity.crmid=vtiger_crmentityrel.relcrmid
                INNER JOIN its4you_receiptcards
                    ON vtiger_crmentity.crmid=its4you_receiptcards.receiptcardid
                WHERE vtiger_crmentity.deleted = 0 
                    AND vtiger_crmentityrel.crmid=? 
                    AND vtiger_crmentityrel.module=? 
                    AND vtiger_crmentityrel.relmodule=?
                    AND its4you_receiptcards.receiptcardstatus IN (" . generateQuestionMarks($_statuses) . ")";
        $params = array_merge(array($this->parentId, "ITS4YouIssuecards", "ITS4YouReceiptcards"), $_statuses);
        $result = $db->pquery($sql, $params);
        $receiptCards = array();
        if ($db->num_rows($result) > 0) {
            while ($row = $db->fetchByAssoc($result)) {
                $receiptCards[$row["relcrmid"]] = $row["receiptcards_no"];
            }
        }

        return $receiptCards;
    }

    /**
     * @return array
     */
    public function getReturnProductsReceiptcards()
    {
        return $this->getRelatedReceiptcards(array("Created", "Delivered"));
    }

    /**
     *
     */
    protected function createParentItems()
    {
        global $adb;

        $sql = "SELECT  vtiger_products.*, 
                        CASE WHEN its4you_warehouses_productrel.quantity != '' THEN its4you_warehouses_productrel.quantity ELSE '0' END AS available_qty,
                        SUM(parent_rel.quantity) AS parent_qty                        
                FROM vtiger_inventoryproductrel AS parent_rel
                INNER JOIN its4you_issuecards
                    ON its4you_issuecards.issuecardid = parent_rel.id
                INNER JOIN vtiger_crmentity
                    ON vtiger_crmentity.crmid=parent_rel.productid
                INNER JOIN vtiger_products
                    ON vtiger_products.productid=parent_rel.productid 
                LEFT JOIN its4you_warehouses_productrel
                    ON its4you_warehouses_productrel.warehouseid = its4you_issuecards.warehouseid
                    AND its4you_warehouses_productrel.productid = parent_rel.productid
                WHERE vtiger_crmentity.deleted = 0 
                    AND parent_rel.id=?                 
                GROUP BY parent_rel.productid 
                ORDER BY parent_rel.sequence_no";
        $result = $adb->pquery($sql, array($this->parentId));

        if ($adb->num_rows($result) > 0) {
            while ($row = $adb->fetchByAssoc($result)) {
                $parentItem = new ITS4YouWarehouses_Item_ActionBlock($row["productid"], $row["productname"], $this->parentId, $row["parent_qty"], $row["available_qty"], ITS4YouWarehouses_ItemInfo_ActionBlock::initialize($row));
                $this->addItem($parentItem);
            }
        }
    }

}
