<?php

/* * *******************************************************************************
 * The content of this file is subject to the MultiWarehouses4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

abstract class ITS4YouWarehouses_DNRelated_ActionBlock  extends ITS4YouWarehouses_Base_ActionBlock
{
    /**
     * @var string
     */
    protected $sourceModule;

    /**
     * @var int
     */
    protected $sourceRecord;

    /**
     * @param string $value
     */
    public function setSourceModule($value)
    {
        $this->sourceModule = $value;
    }

    /**
     * @param int $value
     */
    public function setSourceRecord($value)
    {
        $this->sourceRecord = $value;
    }

    /**
     * @return int
     */
    public function getSourceRecord()
    {
        return $this->sourceRecord;
    }

    /**
     * @return string
     */
    public function getSourceModule()
    {
        return $this->sourceModule;
    }

    /**
     * @param string $_parentModule
     * @param int $_parentId
     * @return ITS4YouWarehouses_INV_ActionBlock|ITS4YouWarehouses_SO_ActionBlock
     * @throws Exception
     */
    public static function factory($_parentModule, $_parentId)
    {
        switch ($_parentModule) {
            case 'SalesOrder':
                return new ITS4YouWarehouses_SO_ActionBlock($_parentId);

            case 'Invoice':
                return new ITS4YouWarehouses_INV_ActionBlock($_parentId);

            default:
                throw new Exception('MultiWarehouses4You :: Unsupported Delivery Notes related action block module.');
        }
    }

    abstract public function isCanceled();

    /**
     * @param $_selectedProducts
     * @return array
     */
    public function getAvailableActionViewModel($_selectedProducts)
    {
        $items = array();
        foreach ($_selectedProducts as $itemid) {
            $item = $this->getItem($itemid);

            if ($item != null && $item->getRestQty() > 0 && $item->getAvailableQty() > 0) {
                if ($item->getRestQty() > $item->getAvailableQty()) {
                    $defaultQty = $item->getAvailableQty();
                } else {
                    $defaultQty = $item->getRestQty();
                }

                $items[$itemid]['name'] = $item->getName();
                $items[$itemid]['available_qty'] = 'Products' === $item->getSEType() ? self::formatNumberForDetailView($item->getAvailableQty()) : ITS4YouWarehouses_Item_ActionBlock::SERVICE_ITEM_AVAIL_QTY;
                $items[$itemid]['default_qty'] = self::formatNumberForEditView($defaultQty);
                $items[$itemid]['todeliver_qty_raw'] = $item->getRestQty();
                $items[$itemid]['todeliver_qty'] = self::formatNumberForDetailView($item->getRestQty());
            }
        }

        return array("items" => $items, "existingDeliveryNotes" => $this->getAvailableDeliveryNotes());
    }

    abstract public function getAvailableDeliveryNotes();

    /**
     * @param $_selectedProducts
     * @return array
     */
    public function getAvailableActionViewModelLineItems($_selectedProducts)
    {
        $lineItems = ITS4YouWarehouses_InventoryLineItem_Helper::getParentLineItems($this->parentId);

        $relatedDeliveryNotes = $this->getRelatedDeliveryNoteIDs(array("Ready to Deliver", "Delivered", "Invoiced"));
        if (count($relatedDeliveryNotes) > 0) {
            $adjustedLineItems = CrossInventoryRelEventHandler::adjustLineItems($lineItems, array_keys($relatedDeliveryNotes));
        } else {
            $adjustedLineItems = $lineItems;
        }
        $lineItems = $adjustedLineItems;

        //since there can be mixture of previous calls getAvailableActionViewModel and getAvailableActionViewModelLineItems
        //it's needed to adjust lineItems quantities
        //firstly, group quantities of all lineItems by productId
        $groupedLineItemQuantities = array();
        foreach ($lineItems as $lineItem) {
            /* @var $lineItem ITS4YouWarehouses_InventoryLineItem_Helper */
            if (isset($groupedLineItemQuantities[$lineItem->getProductId()])) {
                $groupedLineItemQuantities[$lineItem->getProductId()] += $lineItem->getQuantity();
            } else {
                $groupedLineItemQuantities[$lineItem->getProductId()] = $lineItem->getQuantity();
            }
        }
        //secondly, calculate differences between what's on lineItems level and what't on items level
        $groupedQtyDiff = array();
        foreach ($groupedLineItemQuantities as $productId => $groupedQuantity) {
            $groupedQtyDiff[$productId] = $groupedQuantity - $this->getItem($productId)->getRestQty();
        }
        //finally, adjust lineItems quantities
        $availableQuantities = array();

        foreach ($lineItems as $lineItem) {
            $lineItemProductId = $lineItem->getProductId();
            //check grouped rest qty and set lineItem's qty accordingly
            if ($groupedQtyDiff[$lineItemProductId] > 0) {
                $lineItemQtyDiff = $lineItem->getQuantity() - $groupedQtyDiff[$lineItemProductId];
                if ($lineItemQtyDiff < 0) {
                    $lineItem->setQuantity(0);
                    $groupedQtyDiff[$lineItemProductId] = abs($lineItemQtyDiff);
                } else {
                    $lineItem->setQuantity($lineItemQtyDiff);
                    $groupedQtyDiff[$lineItemProductId] = 0;
                }
            }

            //check available quantity and set lineItem's qty accordingly
            $item = $this->getItem($lineItemProductId);
            /* @var $item ITS4YouWarehouses_Item_ActionBlock */
            if ($item !== null) {
                if (!isset($availableQuantities[$lineItemProductId])) {
                    $availableQuantities[$lineItemProductId] = $item->getAvailableQty();
                }

                if ($availableQuantities[$lineItemProductId] > 0) {
                    $lineItemQtyDiff = $availableQuantities[$lineItemProductId] - $lineItem->getQuantity();
                    if ($lineItemQtyDiff < 0) {
                        $lineItem->setQuantity($availableQuantities[$lineItemProductId]);
                        $availableQuantities[$lineItemProductId] = 0;
                    } else {
                        $availableQuantities[$lineItemProductId] = $lineItemQtyDiff;
                    }
                } else {
                    $lineItem->setQuantity(0);
                }
            }
        }

        //if everything is ready, prepare viewmodel
        $items = array();
        foreach ($lineItems as $lineItemId => $lineItem) {
            /* @var $lineItem ITS4YouWarehouses_InventoryLineItem_Helper */
            $productId = $lineItem->getProductId();
            if (!in_array($productId, $_selectedProducts)) {
                continue;
            }

            $item = $this->getItem($productId);
            if ($item != null && $lineItem->getQuantity() > 0) {
                $items[$lineItemId]['productid'] = $productId;
                $items[$lineItemId]['name'] = $item->getName();
                $items[$lineItemId]['available_qty'] = 'Products' === $item->getSEType() ? self::formatNumberForDetailView($item->getAvailableQty()) : ITS4YouWarehouses_Item_ActionBlock::SERVICE_ITEM_AVAIL_QTY;
                $items[$lineItemId]['default_qty'] = self::formatNumberForEditView($lineItem->getQuantity());
                $items[$lineItemId]['todeliver_qty_raw'] = $lineItem->getQuantity();
                $items[$lineItemId]['todeliver_qty'] = self::formatNumberForDetailView($lineItem->getQuantity());
            }
        }

        return array("items" => $items, "existingDeliveryNotes" => $this->getAvailableDeliveryNotes());
    }

    abstract protected function getRelatedDeliveryNoteIDs($_dnStatuses);

    /**
     * @param $_selectedProducts
     * @return array
     * @throws Exception
     */
    public function getNotAvailableActionViewModel($_selectedProducts)
    {
        $items = array();
        $itemQuantities = array();
        $itemIds = array();

        foreach ($_selectedProducts as $itemId) {
            $item = $this->getItem($itemId);

            if ($item && 0 < $item->getStatusQty(ITS4YouWarehouses_ItemStatus_ActionBlock::STATUS_NOTAVAILABLE)) {
                $itemQuantities[$itemId] = $item->getStatusQty(ITS4YouWarehouses_ItemStatus_ActionBlock::STATUS_NOTAVAILABLE);
                $itemIds[$itemId] = $itemId;
            }
        }

        $lineItems = ITS4YouWarehouses_InventoryLineItem_Helper::getParentLineItems($this->parentId, true);
        $qtyInfoEntries = OverallQtyInfoHandler::getQtyInfoEntries($itemIds);

        /* @var $lineItem ITS4YouWarehouses_InventoryLineItem_Helper */
        foreach ($lineItems as $lineItemId => $lineItem) {
            $productId = $lineItem->getProductId();

            if (isset($itemQuantities[$productId])) {
                $item = $this->getItem($productId);
                $itemInfo = $item->getItemInfo();

                $items[$lineItemId] = array(
                    'productid' => $productId,
                    'name' => $item->getName(),
                    'receipt_date' => getNewDisplayDate(),
                    'purchase_cost' => self::formatNumberForEditView($itemInfo->getPurchaseCost()),
                    'price' => self::formatNumberForEditView($itemInfo->getUnitPrice()),
                    'vendorid' => $itemInfo->getVendorId(),
                    'available_qty' => $item->getSEType() == 'Products' ? self::formatNumberForDetailView($item->getAvailableQty()) : ITS4YouWarehouses_Item_ActionBlock::SERVICE_ITEM_AVAIL_QTY,
                    'purchased_qty' => self::formatNumberForDetailView($qtyInfoEntries[$productId]->getToBeReceiptedQty()),
                    'ordered_qty' => self::formatNumberForDetailView($qtyInfoEntries[$productId]->getToBeDeliveredQty()),
                    'reorder_level' => self::formatNumberForDetailView($itemInfo->getReorderLevel()),
                    'optimal_level' => self::formatNumberForDetailView($itemInfo->getOptimalLevel()),
                    'toreceipt_qty' => self::formatNumberForEditView($itemQuantities[$productId]),
                );
            }
        }

        $other['user_date_format'] = Users_Record_Model::getCurrentUserModel()->get('date_format');
        $other['number_of_dec'] = Users_Record_Model::getCurrentUserModel()->get('no_of_currency_decimals');

        return array(
            'items' => $items,
            'other' => $other,
        );
    }

    /**
     * @param $_selectedProducts
     * @return array
     * @throws Exception
     */
    public function getIssuedActionViewModel($_selectedProducts)
    {
        $deliveryNoteIDs = $this->getToBeDeliveredDeliveryNotes();

        $deliveryNotes = array();
        foreach ($deliveryNoteIDs as $deliveryNoteID => $deliveryNoteNo) {
            /* @var $DNActionBlock ITS4YouWarehouses_DN_ActionBlock */
            $DNActionBlock = ITS4YouWarehouses_Base_ActionBlock::factory("ITS4YouWHDeliveryNotes", $deliveryNoteID);
            $containSelItem = false;
            $items = array();
            $DNActionBlockItems = $DNActionBlock->getItems();

            foreach ($DNActionBlockItems as $itemid => $item) {
                /* @var $item ITS4YouWarehouses_Item_ActionBlock */
                if ($item->getStatusQty(ITS4YouWarehouses_ItemStatus_ActionBlock::STATUS_ISSUED) > 0) {
                    if (in_array($itemid, $_selectedProducts)) {
                        $containSelItem = true;
                    }
                    $items[$itemid]["name"] = $item->getName();
                    $items[$itemid]["issued_qty"] = self::formatNumberForDetailView($item->getStatusQty(ITS4YouWarehouses_ItemStatus_ActionBlock::STATUS_ISSUED));
                }
            }
            if ($containSelItem) {
                $deliveryNotes[$deliveryNoteID]["deliveryNoteNo"] = $deliveryNoteNo;
                $deliveryNotes[$deliveryNoteID]["items"] = $items;
            }
        }

        return array("deliveryNotes" => $deliveryNotes);
    }

    abstract public function getToBeDeliveredDeliveryNotes();

    /**
     * @param $_selectedProducts
     * @return array
     * @throws Exception
     */
    public function getToBeInvoicedActionViewModel($_selectedProducts)
    {
        $deliveryNoteIDs = $this->getToBeInvoicedDeliveryNotes();

        $deliveryNotes = array();
        foreach ($deliveryNoteIDs as $deliveryNoteID => $deliveryNoteNo) {
            /* @var $DNActionBlock ITS4YouWarehouses_DN_ActionBlock */
            $DNActionBlock = ITS4YouWarehouses_Base_ActionBlock::factory("ITS4YouWHDeliveryNotes", $deliveryNoteID);
            $containSelItem = false;
            $items = array();
            $DNActionBlockItems = $DNActionBlock->getItems();
            foreach ($DNActionBlockItems as $itemid => $item) {
                /* @var $item ITS4YouWarehouses_Item_ActionBlock */
                if ($item->getStatusQty(ITS4YouWarehouses_ItemStatus_ActionBlock::STATUS_TOBEINVOICED) > 0) {
                    if (in_array($itemid, $_selectedProducts)) {
                        $containSelItem = true;
                    }
                    $items[$itemid]["name"] = $item->getName();
                    $items[$itemid]["issued_qty"] = self::formatNumberForDetailView($item->getStatusQty(ITS4YouWarehouses_ItemStatus_ActionBlock::STATUS_TOBEINVOICED));
                }
            }
            if ($containSelItem) {
                $deliveryNotes[$deliveryNoteID]["deliveryNoteNo"] = $deliveryNoteNo;
                $deliveryNotes[$deliveryNoteID]["items"] = $items;
            }
        }

        return array("deliveryNotes" => $deliveryNotes);
    }

    abstract public function getToBeInvoicedDeliveryNotes();

}
