<?php

/* * *******************************************************************************
 * The content of this file is subject to the MultiWarehouses4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouWarehouses_ActionHandler_ActionBlock
{

    /** @var Vtiger_Request */
    private static $request;

    /** @var Vtiger_Viewer */
    private static $viewer;

    /** @var string */
    private static $module;

    /** @var string */
    private static $sourceModule;

    /** @var int */
    private static $sourceRecord;

    /**
     * @param Vtiger_Request $request
     * @param Vtiger_Viewer $viewer
     * @throws Exception
     */
    public static function handle(Vtiger_Request $request, Vtiger_Viewer $viewer)
    {
        self::$request = $request;
        self::$sourceModule = $request->get("sourceModule");
        self::$sourceRecord = $request->get("sourceRecord");
        self::$module = "ITS4YouWHDeliveryNotes";
        self::$viewer = $viewer;

        $mode = $request->get("mode");
        switch ($mode) {
            case "available":
                self::handleAvailableMode();
                break;

            case "availableSave":
                self::handleAvailableSave();
                break;

            case "issued":
                self::handleIssuedMode();
                break;

            case "issuedSave":
                self::handleIssuedSave();
                break;

            case "toBeInvoiced":
                self::handleToBeInvoicedMode();
                break;

            case "showOverview":
                self::handleShowOverview();
                break;

            case "awaiting":
                self::handleAwaitingMode();
                break;

            case "awaitingSave":
                self::handleAwaitingSave();
                break;

            case "notAvailable":
                self::handleNotAvailableMode();
                break;

            case "notAvailableSave":
                self::handleNotAvailableSave();
                break;
            case "showSummaryWidget":
                self::handleShowSummaryWidget();
                break;

            case "changeStatus":
                self::handleChangeStatus();
                break;

            case "changeStatusCancel":
                self::handleChangeStatusCancel();
                break;

            case "changeStatusDeliver":
                self::handleChangeStatusDeliver();
                break;

            case "checkAvailableDuplicates":
                self::handleCheckAvailableDuplicates();
                break;
            default:
                throw new Exception("Warehouses :: Unsupported action mode ITS4YouWarehouses_ActionHandler_ActionBlock.");
        }
    }

    /**
     *
     */
    private static function handleCheckAvailableDuplicates()
    {
        echo true;
    }

    /**
     * @throws Exception
     */
    private static function handleChangeStatusDeliver()
    {
        self::$viewer->assign("MODULE", self::$module);
        self::$viewer->assign("RECORD", self::$sourceRecord);
        self::$viewer->assign("STATUS_MODE", ITS4YouWarehouses_DN_ActionBlock::ACTION_MODE_DELIVER);

        /* @var $dnActionBlock ITS4YouWarehouses_DN_ActionBlock */
        $dnActionBlock = ITS4YouWarehouses_DN_ActionBlock::factory(self::$module, self::$sourceRecord);
        $viewModel = $dnActionBlock->getChangeStatusDeliverViewModel();
        self::$viewer->assign("VIEWMODEL", $viewModel);

        self::$viewer->view("ActionBlockChangeStatusDeliver.tpl", self::$module);
    }

    /**
     * @throws Exception
     */
    private static function handleChangeStatusCancel()
    {
        self::$viewer->assign("MODULE", self::$module);
        self::$viewer->assign("RECORD", self::$sourceRecord);
        self::$viewer->assign("STATUS_MODE", ITS4YouWarehouses_DN_ActionBlock::ACTION_MODE_CANCEL);
        self::$viewer->view("ActionBlockChangeStatusCancel.tpl", self::$module);
    }

    /**
     * handleShowSummaryWidget
     * function handle Show Summary Widget populate data for correct widget display in SalesOrder, Invoice Detail View
     *
     * for more details see process of /modules/ITS4YouWHDeliveryNotes/views/LoadSummaryWidget.php
     *
     *
     * @throws Exception
     */
    private static function handleShowSummaryWidget()
    {
        $actionBlock = ITS4YouWarehouses_DNRelated_ActionBlock::factory(self::$sourceModule, self::$sourceRecord);
        $viewModel = $actionBlock->getOverviewModel(self::getSelectedProducts());

        self::$viewer->assign("MODULE", self::$module);
        self::$viewer->assign("SOURCE_MODULE", self::$sourceModule);
        self::$viewer->assign("RECORD", self::$sourceRecord);
        self::$viewer->assign("VIEWMODEL", $viewModel);
        self::$viewer->view('LoadSummaryWidget.tpl', self::$module);
    }

    /**
     * @return string
     * @throws Exception
     */
    private static function doChangeStatus() {
        $statusMode = self::$request->get("statusMode");
        $recordModel = Vtiger_Record_Model::getInstanceById(self::$sourceRecord);
        //check whether there is already related invoice despite the status
        $relatedInvoiceId = $recordModel->get("invoice_id");
        $newStatus = "";
        if ($statusMode != ITS4YouWarehouses_DN_ActionBlock::ACTION_MODE_INVOICE || $relatedInvoiceId != "0") {
            $recordModel->set('id', self::$sourceRecord);
            $recordModel->set('mode', 'edit');

            switch ($statusMode) {
                case ITS4YouWarehouses_DN_ActionBlock::ACTION_MODE_CANCEL:
                    $newStatus = "Canceled";
                    $reason = vtranslate("LBL_CANCEL_REASON_COMMENT", "ITS4YouWHDeliveryNotes") . self::$request->get("reason") . "\n\n" . $recordModel->get("description");
                    $recordModel->set("description", $reason);
                    $recordModel->set('deliverynotestatus', $newStatus);
                    $recordModel->save();
                    break;

                case ITS4YouWarehouses_DN_ActionBlock::ACTION_MODE_DELIVER:
                    $newStatus = ($relatedInvoiceId == "0" ? "Delivered" : "Invoiced");
                    //keep original REQUEST
                    $realRequest = $_REQUEST;
                    unset($_REQUEST);
                    if ($relatedInvoiceId == "0") {
                        $quantities = self::$request->get("quantities");
                        $productIds = self::$request->get("products");
                        $todeliverQuantities = array_combine($productIds, $quantities);
                        $lineItems = array();

                        foreach ($productIds as $lineItemId) {
                            $lineItem = ITS4YouWarehouses_InventoryLineItem_Helper::getLineItemFromDB($lineItemId);
                            $lineItem->setQuantity($todeliverQuantities[$lineItemId]);
                            $lineItems[$lineItemId] = $lineItem;
                        }

                        ITS4YouWarehouses_InventoryUtils_Helper::prepareRequestForAssociatedLineItems($lineItems);
                    }
                    $recordModel->set('deliverynotestatus', $newStatus);
                    $recordModel->save();

                    $_REQUEST = $realRequest;
                    break;

                case ITS4YouWarehouses_DN_ActionBlock::ACTION_MODE_INVOICE:
                    $newStatus = "Invoiced";
                    $recordModel->set('deliverynotestatus', $newStatus);
                    $recordModel->save();
                    break;
            }
        }
        return $newStatus;
    }

    /**
     * @throws Exception
     */
    private static function handleChangeStatus()
    {
        $newStatus = self::doChangeStatus();

        if ($newStatus != "") {
            $moduleModel = Vtiger_Module_Model::getInstance(self::$sourceModule);
            /* @var $moduleModel Vtiger_Module_Model */
            $loadUrl = $moduleModel->getDetailViewUrl(self::$sourceRecord);

            switch ($newStatus) {
                case "Canceled":
                    $urlHashTag = "ALERT_DN_STATUS_CHANGE_CANCELED";
                    break;

                case "Delivered":
                    $urlHashTag = "ALERT_DN_STATUS_CHANGE_DELIVERED";
                    break;

                case "Invoiced":
                    $urlHashTag = "ALERT_DN_STATUS_CHANGE_INVOICED";
                    break;

                default:
                    $urlHashTag = "";
            }
            //for info alert - see class DetaliViewHeader.tpl in ITS4YouWHDeliveryNotes templates
            #displayNotifyMsg
            $loadUrl = ($urlHashTag != '' ? $loadUrl . '#' . $urlHashTag : $loadUrl);
            header("Location: $loadUrl");
        } else {
            header("Location: index.php?module=" . self::$sourceModule . "&view=CustomInvoiceEdit&sourceModule=" . self::$sourceModule . "&sourceRecord=" . self::$sourceRecord);
        }
    }

    /**
     * @throws Exception
     */
    private static function handleAvailableMode()
    {
        /* @var $actionBlock ITS4YouWarehouses_Base_ActionBlock */
        /* @var $item ITS4YouWarehouses_Item_ActionBlock */
        $selectedProducts = self::getSelectedProducts();
        $add = self::$request->get("add");

        $actionBlock = ITS4YouWarehouses_DNRelated_ActionBlock::factory(self::$sourceModule, self::$sourceRecord);
        if (self::$request->get("mergeProducts") == "true") {
            $viewModel = $actionBlock->getAvailableActionViewModel($selectedProducts);
        } else {
            $viewModel = $actionBlock->getAvailableActionViewModelLineItems($selectedProducts);
        }

        self::$viewer->assign("MODULE", self::$module);
        self::$viewer->assign("SOURCE_MODULE", self::$sourceModule);
        self::$viewer->assign("RECORD", self::$sourceRecord);
        self::$viewer->assign("VIEWMODEL", $viewModel);
        self::$viewer->assign("ADD", $add);
        self::$viewer->assign("MERGE_PRODUCTS", self::$request->get("mergeProducts"));
        self::$viewer->view("ActionBlockActionAvailable.tpl", self::$module);
    }

    /**
     * @throws Exception
     */
    private static function handleAvailableSave()
    {
        throw new Exception("Warehouses :: ITS4YouWarehouses_ActionHandler_ActionBlock::handleAvailableSave was replaced by custom view AvailableSave.php");
    }

    /**
     * @throws Exception
     */
    private static function handleIssuedMode()
    {
        /* @var $actionBlock ITS4YouWarehouses_Base_ActionBlock */
        /* @var $item ITS4YouWarehouses_Item_ActionBlock */

        $actionBlock = ITS4YouWarehouses_DNRelated_ActionBlock::factory(self::$sourceModule, self::$sourceRecord);
        $viewModel = $actionBlock->getIssuedActionViewModel(self::getSelectedProducts());

        self::$viewer->assign("MODULE", self::$module);
        self::$viewer->assign("SOURCE_MODULE", self::$sourceModule);
        self::$viewer->assign("RECORD", self::$sourceRecord);
        self::$viewer->assign("VIEWMODEL", $viewModel);

        self::$viewer->view("ActionBlockActionIssued.tpl", self::$module);
    }

    /**
     *
     * @throws Exception
     */
    private static function handleIssuedSave()
    {
        $newStatus = "Delivered";
        $langKey = "ALERT_RELATED_DN_DELIVERED";
        if (self::$sourceModule == "Invoice") {
            $newStatus = "Invoiced";
            $langKey = "ALERT_RELATED_DN_INVOICED";
        }

        /* @var $actionBlock ITS4YouWarehouses_SO_ActionBlock */
        $deliveryNotes = self::$request->get("deliveryNoteIDs");
        /* @var $focus ITS4YouWHDeliveryNotes */
        foreach ($deliveryNotes as $deliveryNoteID) {
            ITS4YouWarehouses_DNUtil_ActionBlock::setNewParentStatus($deliveryNoteID, $newStatus);
        }
        // display alert for user
        echo count($deliveryNotes) . " " . vtranslate($langKey, self::$module);
    }

    /**
     * @throws Exception
     */
    private static function handleToBeInvoicedMode()
    {
        /* @var $actionBlock ITS4YouWarehouses_Base_ActionBlock */
        /* @var $item ITS4YouWarehouses_Item_ActionBlock */
        $actionBlock = ITS4YouWarehouses_DNRelated_ActionBlock::factory(self::$sourceModule, self::$sourceRecord);
        $viewModel = $actionBlock->getToBeInvoicedActionViewModel(self::getSelectedProducts());

        self::$viewer->assign("MODULE", self::$module);
        self::$viewer->assign("SOURCE_MODULE", self::$sourceModule);
        self::$viewer->assign("RECORD", self::$sourceRecord);
        self::$viewer->assign("VIEWMODEL", $viewModel);
        self::$viewer->view("ActionBlockActionToBeInvoiced.tpl", self::$module);
    }

    /**
     * @throws Exception
     */
    private static function handleShowOverview()
    {
        $actionBlock = ITS4YouWarehouses_Base_ActionBlock::factory(self::$sourceModule, self::$sourceRecord);
        $viewModel = $actionBlock->getOverviewModel(self::getSelectedProducts());

        self::$viewer->assign("MODULE", self::$module);
        self::$viewer->assign("SOURCE_MODULE", self::$sourceModule);
        self::$viewer->assign("RECORD", self::$sourceRecord);
        self::$viewer->assign("VIEWMODEL", $viewModel);
        self::$viewer->view($viewModel["overviewTemplate"], self::$module);
    }

    /**
     * @throws Exception
     */
    private static function handleAwaitingMode()
    {
        $allowedModules = array("SalesOrder", "PurchaseOrder", "ITS4YouIncomingProducts", "Invoice");
        if (!in_array(self::$sourceModule, $allowedModules)) {   // support for other modules needs to be handled here in this if
            throw new Exception("MultiWarehouses4You :: Unsupported action module." . self::$sourceModule);
        }
        $actionBlock = ITS4YouWarehouses_Base_ActionBlock::factory(self::$sourceModule, self::$sourceRecord);
        $viewModel = $actionBlock->getWaitingAvailabilityActionViewModel(self::getSelectedProducts());

        self::$viewer->assign("MODULE", self::$module);
        self::$viewer->assign("SOURCE_MODULE", self::$sourceModule);
        self::$viewer->assign("RECORD", self::$sourceRecord);
        self::$viewer->assign("VIEWMODEL", $viewModel);

        self::$viewer->view("ActionBlockActionAwaiting.tpl", self::$module);
    }

    /**
     * @throws Exception
     */
    private static function handleAwaitingSave()
    {
        $allowedModules = array("SalesOrder", "PurchaseOrder", "ITS4YouIncomingProducts", "Invoice");
        if (!in_array(self::$sourceModule, $allowedModules)) {   // support for other modules needs to be handled here in this if
            throw new Exception("MultiWarehouses4You :: Unsupported action module.");
        }

        $values = ['product', 'qty', 'price', 'receiptDate', 'productId', 'warehouseId'];
        $lineItems = ITS4YouWarehouses_Products_Helper::getLineItemsFromRequest(self::$request, $values);

        $groups = array();
        $handledPOs = array();

        foreach ($lineItems as $lineItemId => $lineItemValues) {
            $receiptDate = $lineItemValues['receiptDate'];
            $productId = $lineItemValues['productId'];
            $quantity = $lineItemValues['qty'];
            $price = $lineItemValues['price'];
            $warehouseId = $lineItemValues['warehouseId'];

            $dbLineItem = ITS4YouWarehouses_InventoryLineItem_Helper::getLineItemFromDB($lineItemId);

            if ($dbLineItem) {
                $purchaseOrderId = $dbLineItem->getParentId();
                $comment = $dbLineItem->getComment();

                if (!isset($handledPOs[$purchaseOrderId])) {
                    $handledPOs[$purchaseOrderId] = self::getPurchaseOrderInfo($purchaseOrderId);
                }
                $vendorId = $handledPOs[$purchaseOrderId]['vendorid'];

                $lineItem = new ITS4YouWarehouses_InventoryLineItem_Helper($lineItemId, $productId, $quantity, $price, $comment);

                $groups[$vendorId][$receiptDate][$warehouseId]['lineItems'][$lineItemId] = $lineItem;
                $groups[$vendorId][$receiptDate][$warehouseId]['purchaseOrders'][$purchaseOrderId] = $purchaseOrderId;
            }
        }

        $currentUser = Users_Record_Model::getCurrentUserModel();
        $currentUserId = $currentUser->getId();
        $currencyId = $currentUser->get('currency_id');
        $conversionRate = $currentUser->get('conv_rate');
        $regionId = '';
        $parentNo = '';
        $taxType = '';

        switch (self::$sourceModule) {
            case 'SalesOrder':
                $parentRecordInfo = self::getSalesOrderInfo(self::$sourceRecord);
                $parentNo = $parentRecordInfo['salesorder_no'];
                break;

            case 'PurchaseOrder':
                $parentRecordInfo = $handledPOs[self::$sourceRecord];
                $parentNo = $parentRecordInfo['purchaseorder_no'];
                break;

            case 'ITS4YouIncomingProducts':
                $parentNumbers = array();
                ksort($handledPOs);

                foreach ($handledPOs as $parentRecordId => $parentRecordInfo) {
                    $parentNumbers[] = $parentRecordInfo['purchaseorder_no'];
                }

                $parentNo = implode(',', $parentNumbers);
                break;

            case 'Invoice':
                $parentRecordInfo = self::getInvoiceInfo(self::$sourceRecord);
                $parentNo = $parentRecordInfo['invoice_no'];
                break;
        }

        if (!empty($parentRecordInfo)) {
            $currencyId = $parentRecordInfo['currency_id'];
            $conversionRate = $parentRecordInfo['conversion_rate'];
            $taxType = $parentRecordInfo['taxtype'];
            $regionId = $parentRecordInfo['region_id'];
        }

        //keep original REQUEST
        $Real_Request = $_REQUEST;
        unset($_REQUEST);
        $with_crmid = array();
        foreach ($groups as $vendorId => $subArr) {
            foreach ($subArr as $receiptDate => $sub2Arr) {
                foreach ($sub2Arr as $warehouseId => $sub3Arr) {
                    /* @var $rcRecordModel ITS4YouReceiptcards_Record_Model */
                    $rcRecordModel = Vtiger_Record_Model::getCleanInstance('ITS4YouReceiptcards');

                    $rcRecordModel->set('mode', '');
                    $rcRecordModel->set('warehouseid', $warehouseId);
                    $rcRecordModel->set('assigned_user_id', $currentUserId);
                    $rcRecordModel->set('vendor_id', $vendorId);
                    $rcRecordModel->set('adoption_date', DateTimeField::convertToDBFormat($receiptDate));

                    //set purchase order as a reference to receipt card in case there is exactly one parent purchase order
                    if (1 === count($sub3Arr['purchaseOrders'])) {
                        $tmpSubArr = array_keys($sub3Arr['purchaseOrders']);
                        $rcRecordModel->set('referenceid', $tmpSubArr[0]);
                    }

                    $rcRecordModel->set('receiptcardtype', 'From supplier');
                    $rcRecordModel->set('currency_id', $currencyId);
                    $rcRecordModel->set('conversion_rate', $conversionRate);
                    $rcRecordModel->set('region_id', $regionId);

                    $currentDate = date("Y-m-d");
                    if (DateTimeField::convertToDBFormat($receiptDate) <= $currentDate) {
                        $status = "Delivered";
                    } else {
                        $status = "Created";
                    }
                    $rcRecordModel->set("receiptcardstatus", $status);

                    ITS4YouWarehouses_InventoryUtils_Helper::prepareRequestForAssociatedLineItems($sub3Arr["lineItems"]);
                    //store related Purchase Orders to $_REQUEST for OverallQtyInfoHandler.class.php
                    $_REQUEST["qtyInfoHandlerPurchaseOrders"] = $sub3Arr["purchaseOrders"];

                    if(!empty($taxType)) {
                        $_REQUEST['taxtype'] = $taxType;
                    }

                    $rcRecordModel->save();

                    //in case there is just one parent PO - saving to related module is handled within the save_module of ITS4YouReceiptcards.php
                    //otherwise we need to save RC as related records to PO
                    $rcModuleModel = Vtiger_Module_Model::getInstance("ITS4YouReceiptcards");
                    if (count($sub3Arr["purchaseOrders"]) > 1) {
                        foreach ($sub3Arr["purchaseOrders"] as $purchaseOrderId) {
                            $relationModel = Vtiger_Relation_Model::getInstance(Vtiger_Module_Model::getInstance("PurchaseOrder"), $rcModuleModel);
                            /* @var $relationModel Vtiger_Relation_Model */
                            $relationModel->addRelation($purchaseOrderId, $rcRecordModel->getId());
                        }
                    }

                    switch (self::$sourceModule) {
                        //save relation between parent module (Sales Order) and created RC
                        case "SalesOrder":
                            $relationModel = Vtiger_Relation_Model::getInstance(Vtiger_Module_Model::getInstance(self::$sourceModule), $rcModuleModel);
                            /* @var $relationModel Vtiger_Relation_Model */
                            $relationModel->addRelation(self::$sourceRecord, $rcRecordModel->getId());
                            break;

                        //in case we are going from PO module then we need to check whether the PO has related SO and to save newly created RCs also to SO
                        case "PurchaseOrder":
                            $poActionBlock = ITS4YouWarehouses_Base_ActionBlock::factory(self::$sourceModule, self::$sourceRecord);
                            /* @var $poActionBlock ITS4YouWarehouses_PO_ActionBlock */
                            $salesOrderIds = $poActionBlock->getRelatedSalesOrders();
                            foreach ($salesOrderIds as $salesOrderId) {
                                $relationModel = Vtiger_Relation_Model::getInstance(Vtiger_Module_Model::getInstance("SalesOrder"), $rcModuleModel);
                                /* @var $relationModel Vtiger_Relation_Model */
                                $relationModel->addRelation($salesOrderId, $rcRecordModel->getId());
                            }
                            break;
                    }

                    $with_crmid[] = $rcRecordModel->getId();
                    unset($_REQUEST);
                }
            }
        }
        $_REQUEST = $Real_Request;

        //there is direct relationship only between PO and RC, if we are creating RC from SO or any other module then message needs to be changed
        if (self::$sourceModule != "ITS4YouIncomingProducts") {
            $alertMsg = "";
            switch (self::$sourceModule) {
                case "PurchaseOrder":
                    $alertMsg = vtranslate("ALERT_RELATED_RC_CREATED", self::$module);
                    break;

                case "SalesOrder":
                    $alertMsg = vtranslate("ALERT_RELATED_RC_CREATED_INDIRECT", self::$module);
                    break;

                case "Invoice":
                    $alertMsg = vtranslate("ALERT_RELATED_RC_CREATED_INDIRECT2", self::$module);
                    break;
            }
            $notifyMsg = count($with_crmid) . $alertMsg . $parentNo;
        } else {
            $notifyMsg = array(count($with_crmid), "ALERT_RELATED_RC_CREATED", $parentNo);
            #displayNotifyMsg
            header("Location: index.php?module=" . self::$sourceModule . "&view=List#" . join(";", $notifyMsg));
        }

        $response = new Vtiger_Response();
        $response->setResult($notifyMsg);
        $response->emit();
    }

    /**
     * @param $_purchaseOrderId
     * @return array
     */
    private static function getPurchaseOrderInfo($_purchaseOrderId)
    {
        global $adb;

        $entityInfo = array();
        $sql = 'SELECT vtiger_purchaseorder.* 
                FROM vtiger_purchaseorder 
                INNER JOIN vtiger_crmentity
                    ON vtiger_crmentity.crmid = vtiger_purchaseorder.purchaseorderid
                WHERE vtiger_purchaseorder.purchaseorderid=?';
        $result = $adb->pquery($sql, array($_purchaseOrderId));
        if ($adb->num_rows($result) > 0) {
            $row = $adb->fetchByAssoc($result);
            foreach ($row as $key => $val) {
                $entityInfo[$key] = $val;
            }
        }

        return $entityInfo;
    }

    /**
     * @param $_salesOrderId
     * @return array
     */
    private static function getSalesOrderInfo($_salesOrderId)
    {
        global $adb;

        $entityInfo = array();
        $sql = 'SELECT vtiger_salesorder.* 
                FROM vtiger_salesorder 
                INNER JOIN vtiger_crmentity
                    ON vtiger_crmentity.crmid = vtiger_salesorder.salesorderid
                WHERE vtiger_salesorder.salesorderid=?';
        $result = $adb->pquery($sql, array($_salesOrderId));
        if ($adb->num_rows($result) > 0) {
            $row = $adb->fetchByAssoc($result);
            foreach ($row as $key => $val) {
                $entityInfo[$key] = $val;
            }
        }

        return $entityInfo;
    }

    /**
     * @param $_invoiceId
     * @return array
     */
    private static function getInvoiceInfo($_invoiceId)
    {
        global $adb;

        $entityInfo = array();
        $sql = 'SELECT vtiger_invoice.* 
                FROM vtiger_invoice 
                INNER JOIN vtiger_crmentity
                    ON vtiger_crmentity.crmid = vtiger_invoice.invoiceid
                WHERE vtiger_invoice.invoiceid=?';
        $result = $adb->pquery($sql, array($_invoiceId));
        if ($adb->num_rows($result) > 0) {
            $row = $adb->fetchByAssoc($result);
            foreach ($row as $key => $val) {
                $entityInfo[$key] = $val;
            }
        }

        return $entityInfo;
    }

    /**
     * @throws Exception
     */
    private static function handleNotAvailableMode()
    {
        $actionBlock = ITS4YouWarehouses_DNRelated_ActionBlock::factory(self::$sourceModule, self::$sourceRecord);
        $actionBlock->setSourceModule(self::$sourceModule);
        $actionBlock->setSourceRecord(self::$sourceRecord);

        $viewModel = $actionBlock->getNotAvailableActionViewModel(self::getSelectedProducts());

        self::$viewer->assign("MODULE", self::$module);
        self::$viewer->assign("SOURCE_MODULE", self::$sourceModule);
        self::$viewer->assign("RECORD", self::$sourceRecord);
        self::$viewer->assign("VIEWMODEL", $viewModel);

        self::$viewer->view("ActionBlockActionNotAvailable.tpl", self::$module);
    }

    /**
     * @throws Exception
     */
    private static function handleNotAvailableSave()
    {
        $allowedModules = array("SalesOrder", "Invoice");
        if (!in_array(self::$sourceModule, $allowedModules)) {   // support for other modules needs to be handled here in this if
            throw new Exception("MultiWarehouses4You :: Unsupported action module.");
        }

        $values = [
            'product',
            'qty',
            'receiptDate',
            'price',
            'productId',
            'vendorId'
        ];
        $lineItems = ITS4YouWarehouses_Products_Helper::getLineItemsFromRequest(self::$request, $values);
        $lineItemIds = array_keys($lineItems);

        //Customer specific fix of product comments when creating PO from SO or INV
        $lineItemsComments = self::getLineItemsComments($lineItemIds);

        $groups = array();

        foreach ($lineItemIds as $lineItemId) {
            $receiptDate = $lineItems[$lineItemId]['receiptDate'];
            $productId = $lineItems[$lineItemId]['productId'];
            $quantity = $lineItems[$lineItemId]['qty'];
            $price = $lineItems[$lineItemId]['price'];
            $vendorId = $lineItems[$lineItemId]['vendorId'];

            //Customer specific fix of product comments when creating PO from SO or INV
            $comment = $lineItemsComments[$lineItemId];

            $lineItem = new ITS4YouWarehouses_InventoryLineItem_Helper($lineItemId, $productId, $quantity, $price, $comment);
            $groups[$vendorId][$receiptDate][$lineItemId] = $lineItem;
        }

        $settingsModel = Settings_Vtiger_CompanyDetails_Model::getInstance();

        switch (self::$sourceModule) {
            case "SalesOrder":
                $parentInfo = self::getSalesOrderInfo(self::$sourceRecord);
                $parentNo = $parentInfo["salesorder_no"];
                break;

            case "Invoice":
                $parentInfo = self::getInvoiceInfo(self::$sourceRecord);
                $parentNo = $parentInfo["invoice_no"];
                break;

            default:
                $parentInfo = array();
                $parentNo = "";
                break;
        }

        //keep original REQUEST
        $realRequest = $_REQUEST;
        unset($_REQUEST);
        $lineItemsWithoutVendor = array();
        $with_crmid = array();
        foreach ($groups as $vendorId => $subArr) {
            if (empty($vendorId)) {
                foreach ($subArr as $receiptDate => $lineItems) {
                    foreach ($lineItems as $lineItemId => $lineItem) {
                        $lineItemsWithoutVendor[$lineItemId] = $lineItem;
                    }
                }
            } else {
                foreach ($subArr as $receiptDate => $lineItems) {
                    /* @var $poRecordModel PurchaseOrder_Record_Model */
                    $poRecordModel = Vtiger_Record_Model::getCleanInstance("PurchaseOrder");
                    $poRecordModel->set("mode", "");
                    $poRecordModel->set("assigned_user_id", Users_Record_Model::getCurrentUserModel()->getId());
                    $poRecordModel->set("vendor_id", $vendorId);
                    $poRecordModel->set("postatus", "Created");

                    if (isset($parentInfo["contact_id"])) {
                        $poRecordModel->set("contact_id", $parentInfo["contact_id"]);
                    }
                    $poRecordModel->set("subject", $parentInfo["subject"] . " " . $receiptDate);
                    $poRecordModel->set("duedate", DateTimeField::convertToDBFormat($receiptDate));

                    $poRecordModel->set("bill_street", $settingsModel->get("address"));
                    $poRecordModel->set("ship_street", $settingsModel->get("address"));
                    $poRecordModel->set("bill_city", $settingsModel->get("city"));
                    $poRecordModel->set("ship_city", $settingsModel->get("city"));
                    $poRecordModel->set("bill_state", $settingsModel->get("state"));
                    $poRecordModel->set("ship_state", $settingsModel->get("state"));
                    $poRecordModel->set("bill_code", $settingsModel->get("code"));
                    $poRecordModel->set("ship_code", $settingsModel->get("code"));
                    $poRecordModel->set("bill_country", $settingsModel->get("country"));
                    $poRecordModel->set("ship_country", $settingsModel->get("country"));

                    $poRecordModel->set('currency_id', $parentInfo['currency_id']);
                    $poRecordModel->set('conversion_rate', $parentInfo['conversion_rate']);
                    $poRecordModel->set('taxtype', $parentInfo['taxtype']);
                    $poRecordModel->set('region_id', $parentInfo['region_id']);

                    ITS4YouWarehouses_InventoryUtils_Helper::prepareRequestForAssociatedLineItems($lineItems);

                    $_REQUEST['sourceModule'] = $realRequest['sourceModule'];
                    $_REQUEST['sourceRecord'] = $realRequest['sourceRecord'];
                    $_REQUEST['taxtype'] = $parentInfo['taxtype'];
                    $_REQUEST['region_id'] = $parentInfo['region_id'];

                    $poRecordModel->save();

                    $with_crmid[] = $poRecordModel->getId();
                    unset($_REQUEST);
                }
            }
        }
        $_REQUEST = $realRequest;

        if (count($lineItemsWithoutVendor) > 0) {
            Vtiger_Session::set("lineItemsWithoutVendor", serialize($lineItemsWithoutVendor));  //pass $lineItemsWithoutVendor to SESSION for CustomPOEdit.php
            $customViewUrl = "index.php?module=" . self::$module . "&view=CustomPOEdit&sourceModule=" . self::$sourceModule . "&sourceRecord=" . self::$sourceRecord;

            $response = ["url" => $customViewUrl];
        } else {
            $response = count($with_crmid) . vtranslate("ALERT_RELATED_PO_CREATED1", self::$module) . $parentNo;
        }

        $result = new Vtiger_Response();
        $result->setResult($response);
        $result->emit();
    }

    /**
     * Customer specific fix of product comments when creating PO from SO or INV
     * @param $lineItemIds
     * @return array
     */
    private static function getLineItemsComments($lineItemIds)
    {
        global $adb;

        $lineItemsComments = array();
        if (count($lineItemIds) > 0) {
            $sql = "SELECT lineitem_id, comment FROM vtiger_inventoryproductrel WHERE lineitem_id IN (" . generateQuestionMarks($lineItemIds) . ")";
            $result = $adb->pquery($sql, $lineItemIds);

            while ($row = $adb->fetchByAssoc($result)) {
                $lineItemsComments[$row["lineitem_id"]] = $row["comment"];
            }
        }

        return $lineItemsComments;
    }

    /**
     * @return mixed|string|string[]|null
     * @throws Exception
     */
    protected static function getTempWarehouseId()
    {
        global $adb;

        $sql = "SELECT warehouseid 
                FROM its4you_warehouses 
                INNER JOIN vtiger_crmentity
                    ON its4you_warehouses.warehouseid = vtiger_crmentity.crmid
                WHERE vtiger_crmentity.deleted = 0
                ORDER BY its4you_warehouses.warehouseid";
        $result = $adb->pquery($sql, array());

        return $adb->query_result($result, 0, "warehouseid");
    }

    /**
     * @return false|string[]
     */
    public static function getSelectedProducts() {
        return explode(";", self::$request->get("products"));
    }
}
