<?php

/* * *******************************************************************************
 * The content of this file is subject to the MultiWarehouses4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouWarehouses extends CRMEntity
{

    public $log;
    public $db;
    public $table_name = "its4you_warehouses";
    public $table_index = 'warehouseid';

    /**
     * Mandatory table for supporting custom fields.
     */
    public $customFieldTable = Array('its4you_warehousescf', 'warehouseid');

    /**
     * Mandatory for Saving, Include tables related to this module.
     */
    public $tab_name = Array('vtiger_crmentity', 'its4you_warehouses', 'its4you_warehousescf', 'its4you_warehousesshipads');

    /**
     * Mandatory for Saving, Include tablename and tablekey columnname here.
     */
    public $tab_name_index = Array(
        'vtiger_crmentity' => 'crmid',
        'its4you_warehouses' => 'warehouseid',
        'its4you_warehousescf' => 'warehouseid',
        'its4you_warehousesshipads' => 'warehouseid'
    );

    /**
     * Mandatory for Listing (Related listview)
     */
    public $list_fields = Array(
        /* Format: Field Label => Array(tablename, columnname) */
        /* tablename should not have prefix 'vtiger_' */
        'Warehouse Name' => Array('warehouses' => 'warehouse_name'),
        'Assigned To' => Array('crmentity' => 'smownerid')
    );
    public $list_fields_name = Array(
        /* Format: Field Label => fieldname */
        'Warehouse Name' => 'warehouse_name',
        'Assigned To' => 'assigned_user_id'
    );

    /* Make the field link to detail view from list view (Fieldname) */
    public $list_link_field = 'warehouse_name';
    /* For Popup listview and UI type support */
    public $search_fields = Array(
        /* Format: Field Label => Array(tablename, columnname) */
        /* tablename should not have prefix 'vtiger_' */
        'Warehouse Name' => Array('warehouses', 'warehouse_name'),
        'Assigned To' => Array('crmentity', 'smownerid'),
    );
    public $search_fields_name = Array(
        /* Format: Field Label => fieldname */
        'Warehouse Name' => 'warehouse_name',
        'Assigned To' => 'assigned_user_id',
    );
    // For Popup window record selection
    public $popup_fields = Array('warehouse_name');
    // For Alphabetical search
    public $def_basicsearch_col = 'warehouse_name';
    // Column value to use on detail view record text display
    public $def_detailview_recname = 'warehouse_name';
    // Used when enabling/disabling the mandatory fields for the module.
    // Refers to vtiger_field.fieldname values.
    public $mandatory_fields = Array('createdtime', 'modifiedtime', 'warehouse_name');
    public $default_order_by = 'warehouse_name';
    public $default_sort_order = 'ASC';
    public $column_fields;
    public $module_name = 'ITS4YouWarehouses';
    public $moduleName = 'ITS4YouWarehouses';
    public $parentName = 'Inventory';

    public function __construct()
    {
        global $log;

        $this->log = $log;
        $this->db = PearDatabase::getInstance();
        $this->column_fields = getColumnFields($this->moduleName);
    }

    /** Function to handle module specific operations when saving a entity
     */
    public function save_module($module)
    {
    }

    public function vtlib_handler($moduleName, $event_type)
    {
        include_once 'vtlib/Vtiger/Event.php';
        require_once 'vtlib/Vtiger/Module.php';
        require_once 'modules/ModTracker/ModTracker.php';
        require_once 'modules/ModComments/ModComments.php';

        switch ($event_type) {
            case 'module.enabled':
            case 'module.postupdate':
            case 'module.postinstall':
                $this->addCustomLinks();
                break;
            case 'module.preuninstall':
            case 'module.preupdate':
            case 'module.disabled':
                $this->deleteCustomLinks();
                break;
        }
    }

    public function updateNumbering()
    {
        $this->setModuleSeqNumber('configure', $this->moduleName, 'WH', 1);
        $this->updateMissingSeqNumber($this->moduleName);
    }

    /**
     * [module, type, label, url, icon, sequence, handlerInfo]
     * @return array
     */
    public $registerCustomLinks = array(
        ['Products', 'DETAILVIEWSIDEBARWIDGET', 'WHProductInWarehouses', 'module=ITS4YouWHDeliveryNotes&view=ProductInWarehousesBlock'],
        ['ITS4YouWarehouses', 'HEADERSCRIPT', 'ITS4YouWarehouseSeqStatusHandler', 'modules/ITS4YouWarehouses/resources/ITS4YouSeqStatusHandler.js'],
        ['ITS4YouWarehouses', 'HEADERSCRIPT', 'ITS4YouWarehouseUtils', 'modules/ITS4YouWarehouses/resources/ITS4YouUtils.js'],
    );

    /**
     * [events, file, class, condition, dependOn, modules]
     */
    public $registerEventHandler = [
        ['vtiger.entity.aftersave', 'modules/ITS4YouWarehouses/handlers/CustomInvoice.php', 'CustomInvoiceEventHandler', '', '', 'Invoice'],
        ['vtiger.entity.aftersave', 'modules/ITS4YouWarehouses/handlers/CrossInventoryRel.php', 'CrossInventoryRelEventHandler',],
        ['vtiger.entity.aftersave.final', 'modules/ITS4YouWarehouses/handlers/UpdateWarehouse.php', 'UpdateWarehouseAfterSaveEventHandler',],
        ['vtiger.entity.beforesave', 'modules/ITS4YouWarehouses/handlers/UpdateWarehouse.php', 'UpdateWarehouseBeforeSaveEventHandler',],
        ['vtiger.entity.beforedelete', 'modules/ITS4YouWarehouses/handlers/UpdateWarehouse.php', 'UpdateWarehouseBeforeDeleteEventHandler',],
        ['vtiger.entity.afterdelete', 'modules/ITS4YouWarehouses/handlers/UpdateWarehouse.php', 'UpdateWarehouseAfterDeleteEventHandler',],
        [['vtiger.entity.aftersave', 'vtiger.entity.beforesave'], 'modules/ITS4YouWarehouses/handlers/CustomPO.php', 'CustomPOEventHandler', '', '', 'PurchaseOrder',],
    ];

    /**
     * @param bool $register
     */
    public function updateEventHandler($register = true)
    {
        $eventsManager = new VTEventsManager($this->db);

        foreach ($this->registerEventHandler as $data) {
            list($events, $fileName, $className, $condition, $dependOn, $modules) = $data;

            $eventsManager->unregisterHandler($className);

            if ($register) {
                $dependOn = !empty($dependOn) ? $dependOn : '[]';
                $condition = !empty($condition) ? $condition : '';

                foreach ((array)$events as $event) {
                    $eventsManager->registerHandler($event, $fileName, $className, $condition, $dependOn);

                    foreach ((array)$modules as $module) {
                        $eventsManager->setModuleForHandler($module, $className);
                    }
                }
            }
        }
    }

    /**
     * @param bool $register
     */
    public function updateCustomLinks($register = true)
    {
        foreach ($this->registerCustomLinks as $customLink) {
            $module = Vtiger_Module::getInstance($customLink[0]);
            $type = $customLink[1];
            $label = $customLink[2];
            $url = str_replace('$LAYOUT$', Vtiger_Viewer::getDefaultLayoutName(), $customLink[3]);

            if ($module) {
                $module->deleteLink($type, $label);

                if ($register) {
                    $module->addLink($type, $label, $url, $customLink[4], $customLink[5], $customLink[6]);
                }
            }
        }
    }

    public function addCustomLinks()
    {
        $this->clearOldHandlers();
        $this->updateEventHandler();
        $this->updateNumbering();
        $this->updateCustomLinks();
        $this->updateRelatedList();
        $this->updateTables();

        Settings_MenuEditor_Module_Model::addModuleToApp($this->moduleName, $this->parentName);
        ModTracker::enableTrackingForModule(getTabid($this->moduleName));
        ModComments::addWidgetTo([$this->moduleName]);
    }

    public function updateTables()
    {
        $fields = [
            'products_in_warehouse' => "ALTER TABLE its4you_warehouses ADD products_in_warehouse INT(11) DEFAULT NULL",
        ];

        foreach ($fields as $field => $sql) {
            preg_match('/ALTER\ TABLE\ ([a-z0-9\_]+)\ ADD/', $sql, $matches);

            if ($matches[1] && !columnExists($field, $matches[1])) {
                $this->db->pquery($sql);
            }
        }
    }

    public function updateTable() {

    }

    public function clearOldHandlers()
    {
        $this->db->pquery('DELETE FROM vtiger_eventhandlers WHERE handler_path LIKE ?', ['%/ITS4YouWH/%']);
    }

    public function deleteCustomLinks()
    {
        $this->updateEventHandler(false);
        $this->updateCustomLinks(false);
        $this->updateRelatedList(false);
        $this->clearCustomLinks();

        ModTracker::disableTrackingForModule(getTabid($this->moduleName));
        ModComments::removeWidgetFrom([$this->moduleName]);
    }

    public function clearCustomLinks()
    {
        $params = ['ITS4YouUtils'];
        $sql = sprintf('DELETE FROM vtiger_links WHERE linklabel IN (%s)', generateQuestionMarks($params));
        $this->db->pquery($sql, $params);
    }


    /**
     * @var array
     * [module, related module, relate label, related actions, related function]
     * $moduleInstance->setRelatedList($relatedListModule, $relatedLabel, $relatedActions, $relatedFunction);
     */
    public $registerRelatedLists = [
        ['ITS4YouWarehouses', 'ITS4YouWarehouseTransfers', 'ITS4YouWarehouseTransfers', '', 'get_warehousetransfers'],
        ['ITS4YouWarehouses', 'ITS4YouIssuecards', 'ITS4YouIssuecards', '', 'get_issuecards'],
        ['ITS4YouWarehouses', 'ITS4YouReceiptcards', 'ITS4YouReceiptcards', '', 'get_receiptcards'],
        ['ITS4YouWarehouses', 'Documents', 'Documents', 'ADD,SELECT', 'get_attachments'],
        ['Products', 'ITS4YouWarehouses', 'ProductMovements'],
        ['Products', 'ITS4YouWarehouses', 'ProductInWarehouses'],
    ];

    /**
     * @param bool $register
     */
    public function updateRelatedList($register = true)
    {
        foreach ($this->registerRelatedLists as $relatedList) {
            $module = Vtiger_Module::getInstance($relatedList[0]);
            $relatedModule = Vtiger_Module::getInstance($relatedList[1]);

            if ($module && $relatedModule) {
                $relatedLabel = isset($relatedList[2]) ? $relatedList[2] : $relatedModule->name;
                $relatedActions = isset($relatedList[3]) ? $relatedList[3] : '';
                $relatedFunction = isset($relatedList[4]) ? $relatedList[4] : 'get_related_list';

                if ($register) {
                    if ($this->checkRelatedList($module->getId(), $relatedModule->getId(), $relatedLabel, $relatedFunction) == 0) {
                        $module->setRelatedList($relatedModule, $relatedLabel, $relatedActions, $relatedFunction);
                    }
                } else {
                    $module->unsetRelatedList($relatedModule, $relatedLabel, $relatedFunction);
                }
            }
        }
    }

    /**
     * @param $warehouseId
     * @param $cur_tab_id
     * @param $rel_tab_id
     * @param bool $actions
     * @return array
     */
    public function get_warehousetransfers($warehouseId, $cur_tab_id, $rel_tab_id, $actions = false)
    {
        global $log, $singlepane_view, $currentModule;
        $log->debug("Entering get_warehousetransfers(" . $warehouseId . ") method ...");
        $this_module = $currentModule;

        $related_module = "ITS4YouWarehouseTransfers";
        require_once("modules/$related_module/$related_module.php");
        $related_focus = new $related_module();
        vtlib_setup_modulevars($related_module, $related_focus);

        if ($singlepane_view == 'true') {
            $returnset = '&return_module=' . $this_module . '&return_action=DetailView&return_id=' . $warehouseId;
        } else {
            $returnset = '&return_module=' . $this_module . '&return_action=CallRelatedList&return_id=' . $warehouseId;
        }

        $button = '';

        $query = "SELECT its4you_warehousetransfers.*, vtiger_crmentity.*
                    FROM its4you_warehousetransfers
                    INNER JOIN vtiger_crmentity
                            ON its4you_warehousetransfers.warehousetransferid = vtiger_crmentity.crmid
                    WHERE vtiger_crmentity.deleted = 0
                      AND ( its4you_warehousetransfers.fromwarehouseid = " . $warehouseId . " OR its4you_warehousetransfers.towarehouseid = " . $warehouseId . " )";

        $return_value = GetRelatedList($this_module, $related_module, $related_focus, $query, $button, $returnset);

        if ($return_value == null) {
            $return_value = Array();
        }

        $return_value['CUSTOM_BUTTON'] = $button;

        $log->debug("Exiting get_warehousetransfers method ...");
        return $return_value;
    }

    /**
     * @param $warehouseId
     * @param $cur_tab_id
     * @param $rel_tab_id
     * @param bool $actions
     * @return array
     */
    public function get_receiptcards($warehouseId, $cur_tab_id, $rel_tab_id, $actions = false)
    {
        global $log, $singlepane_view, $currentModule;
        $log->debug("Entering get_receiptcards(" . $warehouseId . ") method ...");
        $this_module = $currentModule;

        $related_module = "ITS4YouReceiptcards";
        require_once("modules/$related_module/$related_module.php");
        $related_focus = new $related_module();
        vtlib_setup_modulevars($related_module, $related_focus);

        if ($singlepane_view == 'true') {
            $returnset = '&return_module=' . $this_module . '&return_action=DetailView&return_id=' . $warehouseId;
        } else {
            $returnset = '&return_module=' . $this_module . '&return_action=CallRelatedList&return_id=' . $warehouseId;
        }

        $button = '';

        $query = "SELECT its4you_receiptcards.*, vtiger_crmentity.*
                    FROM its4you_receiptcards
                    INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid=its4you_receiptcards.receiptcardid
                    INNER JOIN its4you_receiptcardscf ON its4you_receiptcardscf.receiptcardid=its4you_receiptcards.receiptcardid
                    WHERE vtiger_crmentity.deleted = 0
                      AND its4you_receiptcards.warehouseid = " . $warehouseId;

        $return_value = GetRelatedList($this_module, $related_module, $related_focus, $query, $button, $returnset);

        if ($return_value == null) {
            $return_value = Array();
        }

        $return_value['CUSTOM_BUTTON'] = $button;

        $log->debug("Exiting get_receiptcards method ...");
        return $return_value;
    }

    /**
     * @param $id
     * @param $cur_tab_id
     * @param $rel_tab_id
     * @param bool $actions
     * @return array
     */
    public function get_issuecards($warehouseId, $cur_tab_id, $rel_tab_id, $actions = false)
    {
        global $log, $singlepane_view, $currentModule;
        $log->debug("Entering get_issuecards(" . $warehouseId . ") method ...");
        $this_module = $currentModule;

        $related_module = "ITS4YouIssuecards";
        require_once("modules/$related_module/$related_module.php");
        $related_focus = new $related_module();
        vtlib_setup_modulevars($related_module, $related_focus);

        if ($singlepane_view == 'true') {
            $returnset = '&return_module=' . $this_module . '&return_action=DetailView&return_id=' . $warehouseId;
        } else {
            $returnset = '&return_module=' . $this_module . '&return_action=CallRelatedList&return_id=' . $warehouseId;
        }

        $button = '';

        $query = "SELECT its4you_issuecards.*, vtiger_crmentity.*
                    FROM its4you_issuecards
                    INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid=its4you_issuecards.issuecardid 
                    INNER JOIN its4you_issuecardscf ON its4you_issuecardscf.issuecardid=its4you_issuecards.issuecardid 
                    WHERE vtiger_crmentity.deleted = 0
                      AND its4you_issuecards.warehouseid = " . $warehouseId;

        $return_value = GetRelatedList($this_module, $related_module, $related_focus, $query, $button, $returnset);

        if ($return_value == null) {
            $return_value = Array();
        }

        $return_value['CUSTOM_BUTTON'] = $button;

        $log->debug("Exiting get_issuecards method ...");
        return $return_value;
    }

    private function checkRelatedList($tabid, $related_tabid, $label, $name = "get_related_list")
    {
        $query = "SELECT relation_id FROM vtiger_relatedlists WHERE tabid=? AND related_tabid=? AND label=? AND name=?";
        $result = $this->db->pquery($query, Array($tabid, $related_tabid, $label, $name));
        return $this->db->num_rows($result);
    }

}