/** @var ITS4YouWarehouses_Detail_Js */
Vtiger_Detail_Js('ITS4YouWarehouses_Detail_Js', {}, {
    registerEvents: function () {
        this._super();
        this.registerProductsInWarehouses();
    },
    registerProductsInWarehouses: function () {
        const params = {
                module: app.getModuleName(),
                record: app.getRecordId(),
                action: 'ProductsInWarehouse',
                mode: 'getRelatedListPageCount',
            },
            badgeHtml = $('<span style="font-weight:normal; margin-left: 10px;" class="numberCircle"></span>');

        app.request.post({data: params}).then(function (error, data) {
            if (!error) {
                if (data['numberOfRecords']) {
                    badgeHtml.text(data['numberOfRecords']);
                    $('[data-label-key="LBL_PRODUCTS_ON_WAREHOUSE"] a').append(badgeHtml);
                }
            }
        });
    },
})